/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.saplanting.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import cool.muyucloud.saplanting.Saplanting;
import cool.muyucloud.saplanting.util.TagUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final Logger LOGGER = Saplanting.getLogger();
    private static final Path CONFIG_PATH = Path.of("config", new String[0]).resolve("saplanting.json");
    private final JsonObject properties;
    private final HashSet<String> langs = new HashSet();
    private final ArrayList<String> keySet;

    public Config() {
        this.langs.add("en_us");
        this.langs.add("zh_cn");
        this.properties = new JsonObject();
        this.properties.addProperty("plantEnable", Boolean.valueOf(true));
        this.properties.addProperty("plantLarge", Boolean.valueOf(true));
        this.properties.addProperty("multiThread", Boolean.valueOf(true));
        this.properties.addProperty("showTitleOnOpConnected", Boolean.valueOf(false));
        this.properties.addProperty("ignoreShape", Boolean.valueOf(false));
        this.properties.addProperty("warnTaskQueue", Boolean.valueOf(true));
        this.properties.addProperty("autoBlackList", Boolean.valueOf(true));
        this.properties.addProperty("plantDelay", (Number)40);
        this.properties.addProperty("avoidDense", (Number)2);
        this.properties.addProperty("playerAround", (Number)2);
        this.properties.addProperty("maxTask", (Number)1000);
        this.properties.addProperty("language", "en_us");
        this.properties.add("blacklist", (JsonElement)new JsonArray());
        this.properties.add("whitelist", (JsonElement)new JsonArray());
        HashSet set = new HashSet(this.properties.keySet());
        set.remove("whitelist");
        set.remove("blacklist");
        set.remove("language");
        this.keySet = new ArrayList(set);
        this.addToWhitelist("#minecraft:saplings");
    }

    public ArrayList<String> getKeySet() {
        return this.keySet;
    }

    public Set<String> getValidLangs() {
        return this.langs;
    }

    public boolean load() {
        boolean bl;
        block22: {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                LOGGER.info("saplanting.json does not exist, generating.");
                try {
                    if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                        Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                    }
                    Files.createFile(CONFIG_PATH, new FileAttribute[0]);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to generate config file at %s.".formatted(CONFIG_PATH));
                    e.printStackTrace();
                    return false;
                }
            }
            InputStream inputStream = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);
            try {
                String value;
                JsonElement element;
                JsonArray array;
                JsonObject read = (JsonObject)new Gson().fromJson(new String(inputStream.readAllBytes(), StandardCharsets.UTF_8), JsonObject.class);
                for (String key : read.keySet()) {
                    if (!this.properties.has(key) || Objects.equals(key, "whitelist") || Objects.equals(key, "blacklist")) continue;
                    JsonPrimitive dst = this.properties.getAsJsonPrimitive(key);
                    JsonPrimitive src = read.get(key).getAsJsonPrimitive();
                    try {
                        if (dst.isBoolean()) {
                            this.properties.addProperty(key, Boolean.valueOf(src.getAsBoolean()));
                            continue;
                        }
                        if (dst.isNumber()) {
                            this.properties.addProperty(key, src.getAsNumber());
                            continue;
                        }
                        if (Objects.equals(key, "language") && !this.langs.contains(src.getAsString())) {
                            this.properties.addProperty(key, "en_us");
                            continue;
                        }
                        this.properties.addProperty(key, src.getAsString());
                    }
                    catch (Exception e) {
                        LOGGER.warn("Problems occurred during analyzing property %s.".formatted(key));
                    }
                }
                if (read.has("whitelist")) {
                    array = read.getAsJsonArray("whitelist");
                    JsonArray whitelist = new JsonArray();
                    this.properties.add("whitelist", (JsonElement)whitelist);
                    for (int i = 0; i < array.size(); ++i) {
                        element = array.get(i);
                        value = element.getAsString();
                        this.addToWhitelist(value);
                    }
                }
                if (read.has("blacklist")) {
                    array = read.getAsJsonArray("blacklist");
                    JsonArray blacklist = new JsonArray();
                    this.properties.add("blacklist", (JsonElement)blacklist);
                    for (int i = 0; i < array.size(); ++i) {
                        element = array.get(i);
                        value = element.getAsString();
                        this.addToBlackList(value);
                    }
                }
                bl = true;
                if (inputStream == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("Problems occurred during reading config file.");
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    public boolean save() {
        boolean bl;
        block11: {
            String json = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.properties);
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                LOGGER.info("saplanting.json does not exist, generating.");
                try {
                    Files.createFile(CONFIG_PATH, new FileAttribute[0]);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to generate config file at %s.".formatted(CONFIG_PATH));
                    e.printStackTrace();
                    return false;
                }
            }
            OutputStream outputStream = Files.newOutputStream(CONFIG_PATH, new OpenOption[0]);
            try {
                outputStream.write(json.getBytes(StandardCharsets.UTF_8));
                bl = true;
                if (outputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("Problems occurred during writing config file.");
                    return false;
                }
            }
            outputStream.close();
        }
        return bl;
    }

    public String getAsString(String key) {
        if (!this.properties.has(key)) {
            throw new NullPointerException("Tried to access property %s but it does not exists!".formatted(key));
        }
        return this.properties.getAsJsonPrimitive(key).getAsString();
    }

    public boolean getAsBoolean(String key) {
        if (!this.properties.has(key)) {
            throw new NullPointerException("Tried to access property %s but it does not exists!".formatted(key));
        }
        JsonPrimitive primitive = this.properties.getAsJsonPrimitive(key);
        if (!primitive.isBoolean()) {
            throw new ClassCastException("Value of property %s is not a bool.".formatted(key));
        }
        return this.properties.get(key).getAsBoolean();
    }

    public int getAsInt(String key) {
        if (!this.properties.has(key)) {
            throw new NullPointerException("Tried to access property %s but it does not exists!".formatted(key));
        }
        JsonPrimitive primitive = this.properties.getAsJsonPrimitive(key);
        if (!primitive.isNumber()) {
            throw new ClassCastException("Value of property %s is not a integer.".formatted(key));
        }
        return this.properties.get(key).getAsInt();
    }

    public boolean set(String key, boolean value) {
        if (!this.properties.has(key)) {
            throw new NullPointerException("Tried to access property %s but it does not exists!".formatted(key));
        }
        JsonPrimitive primitive = this.properties.getAsJsonPrimitive(key);
        if (!primitive.isBoolean()) {
            throw new ClassCastException("Value of property %s is not a bool.".formatted(key));
        }
        if (primitive.getAsBoolean() == value) {
            return false;
        }
        this.properties.addProperty(key, Boolean.valueOf(value));
        return true;
    }

    public boolean set(String key, int value) {
        if (!this.properties.has(key)) {
            throw new NullPointerException("Tried to access property %s but it does not exists!".formatted(key));
        }
        JsonPrimitive primitive = this.properties.getAsJsonPrimitive(key);
        if (!primitive.isNumber()) {
            throw new ClassCastException("Value of property %s is not a integer.".formatted(key));
        }
        if (primitive.getAsNumber().intValue() == value) {
            return false;
        }
        this.properties.addProperty(key, (Number)value);
        return true;
    }

    public boolean set(String key, String value) {
        if (!this.properties.has(key)) {
            throw new NullPointerException("Tried to access property %s but it does not exists!".formatted(key));
        }
        JsonPrimitive primitive = this.properties.getAsJsonPrimitive(key);
        if (!primitive.isString()) {
            throw new ClassCastException("Value of property %s is not a string.".formatted(key));
        }
        if (Objects.equals(primitive.getAsString(), value)) {
            return false;
        }
        this.properties.addProperty(key, value);
        return true;
    }

    public Class<? extends Constable> getType(String key) {
        if (!this.properties.has(key)) {
            throw new NullPointerException("Tried to access property %s but it does not exists!".formatted(key));
        }
        JsonPrimitive primitive = this.properties.get(key).getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            return Boolean.class;
        }
        if (primitive.isNumber()) {
            return Integer.class;
        }
        return String.class;
    }

    public String stringConfigPath() {
        return CONFIG_PATH.toString();
    }

    public boolean isInWhitelist(Item item) {
        if (!this.properties.has("whitelist")) {
            throw new NullPointerException("Tried to access whitelist but it does not exists!");
        }
        JsonElement element = this.properties.get("whitelist");
        if (!element.isJsonArray()) {
            throw new ClassCastException("Value of whitelist is not a array.");
        }
        JsonArray array = element.getAsJsonArray();
        if (array.isEmpty()) {
            return false;
        }
        for (JsonElement e : array) {
            String entry = e.getAsString();
            if (entry.startsWith("#")) {
                TagKey tag = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.parse((String)entry.substring(1)));
                if (!TagUtil.isIn(tag, item)) continue;
                return true;
            }
            if (entry.equals("*")) {
                return true;
            }
            ResourceLocation entryId = ResourceLocation.parse((String)entry);
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
            if (!itemId.equals((Object)entryId)) continue;
            return true;
        }
        return false;
    }

    public boolean addToWhitelist(String value) {
        if (!this.properties.has("whitelist")) {
            throw new NullPointerException("Tried to access whitelist but it does not exists!");
        }
        JsonElement element = this.properties.get("whitelist");
        if (!element.isJsonArray()) {
            throw new ClassCastException("Value of whitelist is not a array.");
        }
        JsonArray array = element.getAsJsonArray();
        String formatted = Config.formatItemLike(value);
        if (formatted == null) {
            return false;
        }
        JsonPrimitive primitive = new JsonPrimitive(formatted);
        if (array.contains((JsonElement)primitive)) {
            return false;
        }
        array.add((JsonElement)primitive);
        return true;
    }

    public boolean removeFromWhitelist(String value) {
        if (!this.properties.has("whitelist")) {
            throw new NullPointerException("Tried to access whitelist but it does not exists!");
        }
        JsonElement element = this.properties.get("whitelist");
        if (!element.isJsonArray()) {
            throw new ClassCastException("Value of whitelist is not a array.");
        }
        JsonArray array = element.getAsJsonArray();
        String formatted = Config.formatItemLike(value);
        if (formatted == null) {
            return false;
        }
        JsonPrimitive primitive = new JsonPrimitive(formatted);
        if (array.contains((JsonElement)primitive)) {
            array.remove((JsonElement)primitive);
            return true;
        }
        return false;
    }

    public int whitelistSize() {
        if (!this.properties.has("whitelist")) {
            throw new NullPointerException("Tried to access whitelist but it does not exists!");
        }
        JsonElement element = this.properties.get("whitelist");
        if (!element.isJsonArray()) {
            throw new ClassCastException("Value of whitelist is not a array.");
        }
        return element.getAsJsonArray().size();
    }

    public JsonArray getWhitelist() {
        if (!this.properties.has("whitelist")) {
            throw new NullPointerException("Tried to access whitelist but it does not exists!");
        }
        JsonElement element = this.properties.get("whitelist");
        if (!element.isJsonArray()) {
            throw new ClassCastException("Value of whitelist is not a array.");
        }
        return element.getAsJsonArray();
    }

    public void clearWhitelist() {
        if (this.properties.has("whitelist")) {
            this.properties.remove("whitelist");
        }
        this.properties.add("whitelist", (JsonElement)new JsonArray());
    }

    public boolean isInBlacklist(Item item) {
        if (!this.properties.has("blacklist")) {
            throw new NullPointerException("Tried to access blacklist but it does not exists!");
        }
        JsonElement element = this.properties.get("blacklist");
        if (!element.isJsonArray()) {
            throw new ClassCastException("Value of blacklist is not a array.");
        }
        JsonArray array = element.getAsJsonArray();
        if (array.isEmpty()) {
            return false;
        }
        for (JsonElement e : array) {
            String entry = e.getAsString();
            if (entry.startsWith("#")) {
                TagKey tag = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.parse((String)entry.substring(1)));
                if (!TagUtil.isIn(tag, item)) continue;
                return true;
            }
            if (entry.equals("*")) {
                return true;
            }
            ResourceLocation entryId = ResourceLocation.parse((String)entry);
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
            if (!itemId.equals((Object)entryId)) continue;
            return true;
        }
        return false;
    }

    public boolean addToBlackList(String value) {
        if (!this.properties.has("blacklist")) {
            throw new NullPointerException("Tried to access blacklist but it does not exists!");
        }
        JsonElement element = this.properties.get("blacklist");
        if (!element.isJsonArray()) {
            throw new ClassCastException("Value of blacklist is not a array.");
        }
        JsonArray array = element.getAsJsonArray();
        String formatted = Config.formatItemLike(value);
        if (formatted == null) {
            return false;
        }
        JsonPrimitive primitive = new JsonPrimitive(formatted);
        if (array.contains((JsonElement)primitive)) {
            return false;
        }
        array.add((JsonElement)primitive);
        return true;
    }

    public boolean removeFromBlackList(String value) {
        JsonPrimitive primitive;
        if (!this.properties.has("blacklist")) {
            throw new NullPointerException("Tried to access blacklist but it does not exists!");
        }
        JsonElement element = this.properties.get("blacklist");
        if (!element.isJsonArray()) {
            throw new ClassCastException("Value of blacklist is not a array.");
        }
        JsonArray array = element.getAsJsonArray();
        if (array.contains((JsonElement)(primitive = new JsonPrimitive(value)))) {
            array.remove((JsonElement)primitive);
            return true;
        }
        return false;
    }

    public int blacklistSize() {
        if (!this.properties.has("blacklist")) {
            throw new NullPointerException("Tried to access blacklist but it does not exists!");
        }
        JsonElement element = this.properties.get("blacklist");
        if (!element.isJsonArray()) {
            throw new ClassCastException("Value of blacklist is not a array.");
        }
        JsonArray array = element.getAsJsonArray();
        return array.size();
    }

    public JsonArray getBlackList() {
        if (!this.properties.has("blacklist")) {
            throw new NullPointerException("Tried to access blacklist but it does not exists!");
        }
        JsonElement element = this.properties.get("blacklist");
        if (!element.isJsonArray()) {
            throw new ClassCastException("Value of blacklist is not a array.");
        }
        return element.getAsJsonArray();
    }

    public void clearBlackList() {
        if (this.properties.has("blacklist")) {
            this.properties.remove("blacklist");
        }
        this.properties.add("blacklist", (JsonElement)new JsonArray());
    }

    @Nullable
    public static String formatItemLike(String itemLike) {
        if (itemLike.startsWith("#")) {
            ResourceLocation id = ResourceLocation.tryParse((String)itemLike.substring(1));
            return id == null ? null : "#" + String.valueOf(id);
        }
        if (itemLike.equals("*")) {
            return "*";
        }
        ResourceLocation id = ResourceLocation.tryParse((String)itemLike);
        return id == null ? null : id.toString();
    }
}

