/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.saplanting.util;

import cool.muyucloud.saplanting.util.FakePlayer;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class PlantContext {
    public static final ConcurrentLinkedQueue<PlantContext> PLANT_TASKS = new ConcurrentLinkedQueue();
    private ItemStack stack;
    private ServerLevel world;
    private BlockPos pos;
    private Boolean large;
    private FakePlayer fakePlayer;

    public void plant() {
        if (this.large.booleanValue()) {
            for (BlockPos tmpPos : BlockPos.betweenClosed((BlockPos)this.pos, (BlockPos)this.pos.offset(1, 0, 1))) {
                this.useOnBlock(tmpPos);
            }
        } else {
            this.useOnBlock();
        }
    }

    private void useOnBlock() {
        this.useOnBlock(this.pos);
    }

    private void useOnBlock(BlockPos pos) {
        this.fakePlayer.setMainHandItem(this.stack);
        UseOnContext context = new UseOnContext((Player)this.fakePlayer, InteractionHand.MAIN_HAND, new BlockHitResult(pos.above().getCenter(), Direction.UP, pos, false));
        InteractionResult result = this.stack.useOn(context);
        this.fakePlayer.removeMainHandItem();
        Item item = this.stack.getItem();
        if (result.consumesAction()) {
            item.finishUsingItem(this.stack, (Level)this.world, (LivingEntity)this.fakePlayer);
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public Level getWorld() {
        return this.world;
    }

    public void setWorld(ServerLevel world) {
        this.world = world;
        this.fakePlayer = FakePlayer.get((Level)world);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public Boolean isLarge() {
        return this.large;
    }

    public void setLarge(Boolean large) {
        this.large = large;
    }
}

