/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.saplanting.util;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class Translation {
    private static final Translation TRANSLATION = new Translation();
    private HashMap<String, String> map;

    public Translation() {
        String json;
        try {
            json = IOUtils.toString((InputStream)Objects.requireNonNull(Translation.class.getClassLoader().getResourceAsStream("assets/saplanting/lang/en_us.json")), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new NullPointerException("Can not read default language file!");
        }
        this.map = (HashMap)new Gson().fromJson(json, new TypeToken<HashMap<String, String>>(){}.getType());
    }

    public static String translate(String key) {
        if (Translation.TRANSLATION.map.containsKey(key)) {
            return Translation.TRANSLATION.map.get(key);
        }
        return key;
    }

    public static void updateLanguage(String name) {
        String json;
        try {
            json = IOUtils.toString((InputStream)Objects.requireNonNull(Translation.class.getClassLoader().getResourceAsStream("assets/saplanting/lang/%s.json".formatted(name))), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return;
        }
        Translation.TRANSLATION.map = (HashMap)new Gson().fromJson(json, new TypeToken<HashMap<String, String>>(){}.getType());
    }
}

