/*
 * Decompiled with CFR 0.152.
 */
package palamod.client.renderer.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemModels;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperties;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperties;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterItemModelsEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class LegacyOverrideSelectItemModel
implements ItemModel {
    private final ModelOverride[] overrides;
    private final ItemModel[] models;
    private final ItemModel fallback;

    private LegacyOverrideSelectItemModel(ModelOverride[] overrides, ItemModel[] models, ItemModel fallback) {
        this.overrides = overrides;
        this.models = models;
        this.fallback = fallback;
    }

    public void update(ItemStackRenderState renderState, ItemStack itemStack, ItemModelResolver modelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        ItemModel model = this.fallback;
        for (int i = this.overrides.length - 1; i >= 0; --i) {
            if (!this.overrides[i].test(itemStack, level, entity, seed, displayContext)) continue;
            model = this.models[i];
            break;
        }
        model.update(renderState, itemStack, modelResolver, displayContext, level, entity, seed);
    }

    @SubscribeEvent
    public static void registerItemModelTypes(RegisterItemModelsEvent event) {
        event.register(ResourceLocation.parse((String)"palamod:legacy_overrides"), Unbaked.MAP_CODEC);
    }

    public record ModelOverride(List<PredicateEntry> predicate, ItemModel.Unbaked model) {
        public static final Codec<ModelOverride> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PredicateEntry.CODEC.listOf().fieldOf("predicate").forGetter(ModelOverride::predicate), (App)ItemModels.CODEC.fieldOf("model").forGetter(ModelOverride::model)).apply((Applicative)instance, ModelOverride::new));

        public boolean test(ItemStack itemStack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed, ItemDisplayContext displayContext) {
            boolean flag = true;
            for (PredicateEntry entry : this.predicate) {
                flag &= entry.test(itemStack, level, entity, seed, displayContext);
            }
            return flag;
        }
    }

    public record Unbaked(List<ModelOverride> overrides, ItemModel.Unbaked fallback) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ModelOverride.CODEC.listOf().fieldOf("overrides").forGetter(Unbaked::overrides), (App)ItemModels.CODEC.fieldOf("fallback").forGetter(Unbaked::fallback)).apply((Applicative)instance, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public ItemModel bake(ItemModel.BakingContext bakingContext) {
            ItemModel[] models = new ItemModel[this.overrides.size()];
            for (int i = 0; i < this.overrides.size(); ++i) {
                models[i] = this.overrides.get((int)i).model.bake(bakingContext);
            }
            return new LegacyOverrideSelectItemModel((ModelOverride[])this.overrides.toArray(ModelOverride[]::new), models, this.fallback.bake(bakingContext));
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            this.fallback.resolveDependencies(resolver);
            this.overrides.forEach(override -> override.model.resolveDependencies(resolver));
        }
    }

    public static interface PredicateEntry {
        public static final Codec<PredicateEntry> CODEC = Codec.either(FloatEntry.CODEC, BoolEntry.CODEC).xmap(Either::unwrap, predicate -> {
            if (predicate instanceof FloatEntry) {
                FloatEntry floatPredicate = (FloatEntry)predicate;
                return Either.left((Object)floatPredicate);
            }
            if (predicate instanceof BoolEntry) {
                BoolEntry boolPredicate = (BoolEntry)predicate;
                return Either.right((Object)boolPredicate);
            }
            throw new UnsupportedOperationException();
        });

        public boolean test(ItemStack var1, @Nullable ClientLevel var2, @Nullable LivingEntity var3, int var4, ItemDisplayContext var5);
    }

    public record BoolEntry(ConditionalItemModelProperty property, boolean value) implements PredicateEntry
    {
        public static final Codec<BoolEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConditionalItemModelProperties.MAP_CODEC.fieldOf("property").forGetter(BoolEntry::property), (App)Codec.BOOL.fieldOf("value").forGetter(BoolEntry::value)).apply((Applicative)instance, BoolEntry::new));

        @Override
        public boolean test(ItemStack itemStack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed, ItemDisplayContext displayContext) {
            return this.property.get(itemStack, level, entity, seed, displayContext) || !this.value;
        }
    }

    public record FloatEntry(RangeSelectItemModelProperty property, float value) implements PredicateEntry
    {
        public static final Codec<FloatEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RangeSelectItemModelProperties.MAP_CODEC.fieldOf("property").forGetter(FloatEntry::property), (App)Codec.FLOAT.fieldOf("value").forGetter(FloatEntry::value)).apply((Applicative)instance, FloatEntry::new));

        @Override
        public boolean test(ItemStack itemStack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed, ItemDisplayContext displayContext) {
            return this.property.get(itemStack, level, entity, seed) >= this.value;
        }
    }
}

