/*
 * Decompiled with CFR 0.152.
 */
package palamod.item;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.neoforged.neoforge.registries.DeferredHolder;
import palamod.procedures.FullendiuminvisibleProcedure;

public abstract class EndiumArmorItem
extends Item {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(400, Map.of(ArmorType.BOOTS, 10, ArmorType.LEGGINGS, 6, ArmorType.CHESTPLATE, 12, ArmorType.HELMET, 10, ArmorType.BODY, 12), 70, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_netherite")), 5.0f, 0.3f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"palamod:endium_armor_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"palamod:endium_armor")));

    private EndiumArmorItem(Item.Properties properties) {
        super(properties);
    }

    public static class Boots
    extends EndiumArmorItem {
        public Boots(Item.Properties properties) {
            super(properties.fireResistant().humanoidArmor(ARMOR_MATERIAL, ArmorType.BOOTS));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    FullendiuminvisibleProcedure.execute(entity);
                }
            }
        }
    }

    public static class Leggings
    extends EndiumArmorItem {
        public Leggings(Item.Properties properties) {
            super(properties.fireResistant().humanoidArmor(ARMOR_MATERIAL, ArmorType.LEGGINGS));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    FullendiuminvisibleProcedure.execute(entity);
                }
            }
        }
    }

    public static class Chestplate
    extends EndiumArmorItem {
        public Chestplate(Item.Properties properties) {
            super(properties.fireResistant().humanoidArmor(ARMOR_MATERIAL, ArmorType.CHESTPLATE));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    FullendiuminvisibleProcedure.execute(entity);
                }
            }
        }
    }

    public static class Helmet
    extends EndiumArmorItem {
        public Helmet(Item.Properties properties) {
            super(properties.fireResistant().humanoidArmor(ARMOR_MATERIAL, ArmorType.HELMET));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    FullendiuminvisibleProcedure.execute(entity);
                }
            }
        }
    }
}

