/*
 * Decompiled with CFR 0.152.
 */
package palamod.item.inventory;

import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.items.ComponentItemHandler;
import palamod.init.PalamodModItems;
import palamod.world.inventory.TrashguiMenu;

@EventBusSubscriber
public class VoidstoneInventoryCapability
extends ComponentItemHandler {
    @SubscribeEvent
    public static void onItemDropped(ItemTossEvent event) {
        if (event.getEntity().getItem().getItem() == PalamodModItems.VOIDSTONE.get()) {
            Player player = event.getPlayer();
            if (player.containerMenu instanceof TrashguiMenu) {
                player.closeContainer();
            }
        }
    }

    public VoidstoneInventoryCapability(MutableDataComponentHolder parent) {
        super(parent, DataComponents.CONTAINER, 1);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.getItem() != PalamodModItems.VOIDSTONE.get();
    }

    public ItemStack getStackInSlot(int slot) {
        return super.getStackInSlot(slot).copy();
    }
}

