/*
 * Decompiled with CFR 0.152.
 */
package palamod.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import palamod.init.PalamodModScreens;
import palamod.network.SpecialmoneypanelButtonMessage;
import palamod.world.inventory.SpecialmoneypanelMenu;

public class SpecialmoneypanelScreen
extends AbstractContainerScreen<SpecialmoneypanelMenu>
implements PalamodModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private EditBox player_name;
    private EditBox money;
    private Checkbox custom_destructible;
    private Button button_give;

    public SpecialmoneypanelScreen(SpecialmoneypanelMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 224;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("player_name")) {
                this.player_name.setValue(stringState);
            } else if (name.equals("money")) {
                this.money.setValue(stringState);
            }
        }
        if (elementType == 1 && elementState instanceof Boolean) {
            Boolean logicState = (Boolean)elementState;
            if (name.equals("custom_destructible") && this.custom_destructible.selected() != logicState.booleanValue()) {
                this.custom_destructible.onPress();
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.player_name.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.money.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.parse((String)"palamod:textures/screens/specialmoneypanel.png"), this.leftPos + -1, this.topPos + 0, 0.0f, 0.0f, 176, 224, 176, 224);
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.player_name.isFocused()) {
            return this.player_name.keyPressed(key, b, c);
        }
        if (this.money.isFocused()) {
            return this.money.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String player_nameValue = this.player_name.getValue();
        String moneyValue = this.money.getValue();
        super.resize(minecraft, width, height);
        this.player_name.setValue(player_nameValue);
        this.money.setValue(moneyValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.palamod.specialmoneypanel.label_specific_player"), 26, 8, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.palamod.specialmoneypanel.label_amount_of_money"), 26, 40, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.palamod.specialmoneypanel.label_item_default_money_item"), 7, 74, -12829636, false);
    }

    public void init() {
        super.init();
        this.player_name = new EditBox(this.font, this.leftPos + 8, this.topPos + 19, 118, 18, (Component)Component.translatable((String)"gui.palamod.specialmoneypanel.player_name"));
        this.player_name.setMaxLength(8192);
        this.player_name.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((SpecialmoneypanelMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "player_name", content, false);
            }
        });
        this.player_name.setHint((Component)Component.translatable((String)"gui.palamod.specialmoneypanel.player_name"));
        this.addWidget((GuiEventListener)this.player_name);
        this.money = new EditBox(this.font, this.leftPos + 8, this.topPos + 51, 118, 18, (Component)Component.translatable((String)"gui.palamod.specialmoneypanel.money"));
        this.money.setMaxLength(8192);
        this.money.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((SpecialmoneypanelMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "money", content, false);
            }
        });
        this.money.setHint((Component)Component.translatable((String)"gui.palamod.specialmoneypanel.money"));
        this.addWidget((GuiEventListener)this.money);
        this.button_give = Button.builder((Component)Component.translatable((String)"gui.palamod.specialmoneypanel.button_give"), e -> {
            int x = this.x;
            int y = this.y;
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SpecialmoneypanelButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SpecialmoneypanelButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 119, this.topPos + 90, 46, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_give);
        this.custom_destructible = Checkbox.builder((Component)Component.translatable((String)"gui.palamod.specialmoneypanel.custom_destructible"), (Font)this.font).pos(this.leftPos + 6, this.topPos + 114).onValueChange((checkbox, value) -> {
            if (!this.menuStateUpdateActive) {
                ((SpecialmoneypanelMenu)this.menu).sendMenuStateUpdate(this.entity, 1, "custom_destructible", value, false);
            }
        }).build();
        this.addRenderableWidget((GuiEventListener)this.custom_destructible);
    }
}

