/*
 * Decompiled with CFR 0.152.
 */
package palamod.item;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import palamod.procedures.ClearhanggliderProcedure;
import palamod.procedures.HangboostProcedure;

public class HanggliderItem
extends Item {
    public HanggliderItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, tooltipDisplay, componentConsumer, flag);
        componentConsumer.accept((Component)Component.translatable((String)"item.palamod.hang_glider.description_0"));
    }

    public InteractionResult use(Level world, Player entity, InteractionHand hand) {
        InteractionResult ar = super.use(world, entity, hand);
        HangboostProcedure.execute((Entity)entity, entity.getItemInHand(hand));
        return ar;
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        HangboostProcedure.execute((Entity)entity, itemstack);
        return retval;
    }

    public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
        super.inventoryTick(itemstack, world, entity, equipmentSlot);
        ClearhanggliderProcedure.execute(entity);
    }

    public boolean onDroppedByPlayer(ItemStack itemstack, Player entity) {
        ClearhanggliderProcedure.execute((Entity)entity);
        return true;
    }
}

