/*
 * Decompiled with CFR 0.152.
 */
package palamod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import palamod.procedures.SlowgreenglowballProcedure;

public class GreenglueballBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public GreenglueballBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.SLIME_BLOCK).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).ignitedByLava());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)GreenglueballBlock.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)1.0, (double)11.0), (VoxelShape[])new VoxelShape[]{GreenglueballBlock.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)1.0, (double)5.0), GreenglueballBlock.box((double)1.0, (double)0.0, (double)11.0, (double)15.0, (double)1.0, (double)13.0), GreenglueballBlock.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)1.0, (double)3.0), GreenglueballBlock.box((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0, (double)15.0), GreenglueballBlock.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)1.0, (double)1.0), GreenglueballBlock.box((double)5.0, (double)0.0, (double)15.0, (double)11.0, (double)1.0, (double)16.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)GreenglueballBlock.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)1.0, (double)11.0), (VoxelShape[])new VoxelShape[]{GreenglueballBlock.box((double)1.0, (double)0.0, (double)11.0, (double)15.0, (double)1.0, (double)13.0), GreenglueballBlock.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)1.0, (double)5.0), GreenglueballBlock.box((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0, (double)15.0), GreenglueballBlock.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)1.0, (double)3.0), GreenglueballBlock.box((double)5.0, (double)0.0, (double)15.0, (double)11.0, (double)1.0, (double)16.0), GreenglueballBlock.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)1.0, (double)1.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)GreenglueballBlock.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{GreenglueballBlock.box((double)3.0, (double)0.0, (double)1.0, (double)5.0, (double)1.0, (double)15.0), GreenglueballBlock.box((double)11.0, (double)0.0, (double)1.0, (double)13.0, (double)1.0, (double)15.0), GreenglueballBlock.box((double)1.0, (double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0), GreenglueballBlock.box((double)13.0, (double)0.0, (double)3.0, (double)15.0, (double)1.0, (double)13.0), GreenglueballBlock.box((double)0.0, (double)0.0, (double)5.0, (double)1.0, (double)1.0, (double)11.0), GreenglueballBlock.box((double)15.0, (double)0.0, (double)5.0, (double)16.0, (double)1.0, (double)11.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)GreenglueballBlock.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{GreenglueballBlock.box((double)11.0, (double)0.0, (double)1.0, (double)13.0, (double)1.0, (double)15.0), GreenglueballBlock.box((double)3.0, (double)0.0, (double)1.0, (double)5.0, (double)1.0, (double)15.0), GreenglueballBlock.box((double)13.0, (double)0.0, (double)3.0, (double)15.0, (double)1.0, (double)13.0), GreenglueballBlock.box((double)1.0, (double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0), GreenglueballBlock.box((double)15.0, (double)0.0, (double)5.0, (double)16.0, (double)1.0, (double)11.0), GreenglueballBlock.box((double)0.0, (double)0.0, (double)5.0, (double)1.0, (double)1.0, (double)11.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)Direction.NORTH);
        }
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.entityInside(blockstate, world, pos, entity);
        SlowgreenglowballProcedure.execute(entity);
    }
}

