/*
 * Decompiled with CFR 0.152.
 */
package palamod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import palamod.init.PalamodModScreens;
import palamod.network.AuthsafeguiButtonMessage;
import palamod.world.inventory.AuthsafeguiMenu;

public class AuthsafeguiScreen
extends AbstractContainerScreen<AuthsafeguiMenu>
implements PalamodModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    EditBox code_check;
    Button button_open;

    public AuthsafeguiScreen(AuthsafeguiMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 150;
        this.imageHeight = 60;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("code_check")) {
                this.code_check.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.code_check.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(RenderType::guiTextured, ResourceLocation.parse((String)"palamod:textures/screens/authsafegui.png"), this.leftPos + -1, this.topPos + 0, 0.0f, 0.0f, 150, 60, 150, 60);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.code_check.isFocused()) {
            return this.code_check.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String code_checkValue = this.code_check.getValue();
        super.resize(minecraft, width, height);
        this.code_check.setValue(code_checkValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.palamod.authsafegui.label_enter_code"), 3, 6, -12829636, false);
    }

    public void init() {
        super.init();
        this.code_check = new EditBox(this.font, this.leftPos + 4, this.topPos + 16, 118, 18, (Component)Component.translatable((String)"gui.palamod.authsafegui.code_check"));
        this.code_check.setMaxLength(8192);
        this.code_check.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((AuthsafeguiMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "code_check", content, false);
            }
        });
        this.addWidget((GuiEventListener)this.code_check);
        this.button_open = Button.builder((Component)Component.translatable((String)"gui.palamod.authsafegui.button_open"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new AuthsafeguiButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            AuthsafeguiButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 3, this.topPos + 36, 46, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_open);
    }
}

