/*
 * Decompiled with CFR 0.152.
 */
package palamod.jei_recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import palamod.jei_recipes.EmptyIngredient;

public record CrusherrecipetypeRecipe(ItemStack output, List<Ingredient> recipeItems) implements Recipe<RecipeInput>
{
    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.create(this.recipeItems);
    }

    public boolean matches(RecipeInput pContainer, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        return false;
    }

    public List<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider holder) {
        return this.output;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeType<? extends Recipe<RecipeInput>> getType() {
        return Type.INSTANCE;
    }

    public RecipeSerializer<? extends Recipe<RecipeInput>> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Type
    implements RecipeType<CrusherrecipetypeRecipe> {
        public static final RecipeType<CrusherrecipetypeRecipe> INSTANCE = new Type();

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<CrusherrecipetypeRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<CrusherrecipetypeRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.STRICT_CODEC.fieldOf("output").forGetter(CrusherrecipetypeRecipe::output), (App)Ingredient.CODEC.listOf().fieldOf("ingredients").forGetter(CrusherrecipetypeRecipe::recipeItems)).apply((Applicative)builder, CrusherrecipetypeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CrusherrecipetypeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CrusherrecipetypeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CrusherrecipetypeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static CrusherrecipetypeRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.withSize((int)buf.readVarInt(), (Object)EmptyIngredient.create());
            inputs.replaceAll(ingredients -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            return new CrusherrecipetypeRecipe((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf), (List<Ingredient>)inputs);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, CrusherrecipetypeRecipe recipe) {
            buf.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ing : recipe.getIngredients()) {
                if (((Holder)ing.items().findFirst().get()).value() == Items.AIR) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)EmptyIngredient.create());
                    continue;
                }
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ing);
            }
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getResultItem(null));
        }
    }
}

