/*
 * Decompiled with CFR 0.152.
 */
package palamod.procedures;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import palamod.init.PalamodModItems;

public class DamagestickprocessProcedure {
    public static void execute(LevelAccessor world, Entity entity, ItemStack itemstack) {
        if (entity == null) {
            return;
        }
        if (((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("cooldown") == 0.0 || DamagestickprocessProcedure.getEntityGameType(entity) == GameType.CREATIVE) {
            for (int index0 = 0; index0 < 25; ++index0) {
                Entity _shootFrom = entity;
                Level projectileLevel = _shootFrom.level();
                if (projectileLevel.isClientSide()) continue;
                AbstractArrow _entityToSpawn = DamagestickprocessProcedure.initArrowProjectile((AbstractArrow)new Arrow(projectileLevel, 0.0, 0.0, 0.0, new Arrow(EntityType.ARROW, projectileLevel).getPickupItemStackOrigin(), DamagestickprocessProcedure.createArrowWeaponItemStack(projectileLevel, 7, (byte)0)), entity, 0.25f, false, false, false, AbstractArrow.Pickup.CREATIVE_ONLY);
                _entityToSpawn.setPos(_shootFrom.getX(), _shootFrom.getEyeY() - 0.1, _shootFrom.getZ());
                _entityToSpawn.shoot(_shootFrom.getLookAngle().x, _shootFrom.getLookAngle().y, _shootFrom.getLookAngle().z, 2.0f, 0.0f);
                projectileLevel.addFreshEntity((Entity)_entityToSpawn);
            }
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                itemstack.hurtAndBreak(1, _level, null, _stkprov -> {});
            }
            String _tagName = "name";
            String _tagValue = new ItemStack((ItemLike)PalamodModItems.DAMAGESTICK.get()).getDisplayName().getString();
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putString("name", _tagValue));
            _tagName = "cooldown";
            double _tagValue2 = 48000.0;
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putDouble("cooldown", 48000.0));
        }
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }

    private static AbstractArrow initArrowProjectile(AbstractArrow entityToSpawn, Entity shooter, float damage, boolean silent, boolean fire, boolean particles, AbstractArrow.Pickup pickup) {
        entityToSpawn.setOwner(shooter);
        entityToSpawn.setBaseDamage((double)damage);
        if (silent) {
            entityToSpawn.setSilent(true);
        }
        if (fire) {
            entityToSpawn.igniteForSeconds(100.0f);
        }
        if (particles) {
            entityToSpawn.setCritArrow(true);
        }
        entityToSpawn.pickup = pickup;
        return entityToSpawn;
    }

    private static ItemStack createArrowWeaponItemStack(Level level, int knockback, byte piercing) {
        ItemStack weapon = new ItemStack((ItemLike)Items.ARROW);
        if (knockback > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), knockback);
        }
        if (piercing > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.PIERCING), (int)piercing);
        }
        return weapon;
    }
}

