/*
 * Decompiled with CFR 0.152.
 */
package palamod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import palamod.init.PalamodModScreens;
import palamod.network.PhoneguiButtonMessage;
import palamod.world.inventory.PhoneguiMenu;

public class PhoneguiScreen
extends AbstractContainerScreen<PhoneguiMenu>
implements PalamodModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private EditBox cheat_code_secret;
    private Button button_test_code;

    public PhoneguiScreen(PhoneguiMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("cheat_code_secret")) {
                this.cheat_code_secret.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.cheat_code_secret.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(ResourceLocation.parse((String)"palamod:textures/screens/phonegui.png"), this.leftPos + -1, this.topPos + 0, 0.0f, 0.0f, 176, 166, 176, 166);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.cheat_code_secret.isFocused()) {
            return this.cheat_code_secret.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String cheat_code_secretValue = this.cheat_code_secret.getValue();
        super.resize(minecraft, width, height);
        this.cheat_code_secret.setValue(cheat_code_secretValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.palamod.phonegui.label_enter_your_secret_code"), 4, 7, -12829636, false);
    }

    public void init() {
        super.init();
        this.cheat_code_secret = new EditBox(this.font, this.leftPos + 5, this.topPos + 21, 118, 18, (Component)Component.translatable((String)"gui.palamod.phonegui.cheat_code_secret"));
        this.cheat_code_secret.setMaxLength(8192);
        this.cheat_code_secret.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((PhoneguiMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "cheat_code_secret", content, false);
            }
        });
        this.cheat_code_secret.setHint((Component)Component.translatable((String)"gui.palamod.phonegui.cheat_code_secret"));
        this.addWidget((GuiEventListener)this.cheat_code_secret);
        this.button_test_code = Button.builder((Component)Component.translatable((String)"gui.palamod.phonegui.button_test_code"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new PhoneguiButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PhoneguiButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 98, this.topPos + 57, 72, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_test_code);
    }
}

