/*
 * Decompiled with CFR 0.152.
 */
package palamod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import palamod.procedures.GetguardianlevelProcedure;
import palamod.procedures.GetguardianpvProcedure;
import palamod.procedures.GuardianentityproviderProcedure;
import palamod.world.inventory.GuardianguiMenu;

public class GuardianguiScreen
extends AbstractContainerScreen<GuardianguiMenu> {
    private static final HashMap<String, Object> guistate = GuardianguiMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    Button button_arbre_de_competance;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"palamod:textures/screens/guardiangui.png");

    public GuardianguiScreen(GuardianguiMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 310;
        this.imageHeight = 200;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = GuardianentityproviderProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + 55, this.topPos + 75, 30, 0.0f, 0.0f, livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(ResourceLocation.parse((String)"palamod:textures/screens/golem_blackground.png"), this.leftPos + 21, this.topPos + 6, 0.0f, 0.0f, 64, 128, 64, 128);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.palamod.guardiangui.label_degats"), 215, 67, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.palamod.guardiangui.label_pv"), 273, 67, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.palamod.guardiangui.label_golem"), 140, 8, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.palamod.guardiangui.label_level"), 125, 29, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.palamod.guardiangui.label_renommer"), 112, 69, -256, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.palamod.guardiangui.label_whitelist"), 158, 70, -65536, false);
        guiGraphics.drawString(this.font, GetguardianlevelProcedure.execute(), 156, 29, -65485, false);
        guiGraphics.drawString(this.font, GetguardianpvProcedure.execute(), 260, 85, -65434, false);
    }

    public void init() {
        super.init();
        this.button_arbre_de_competance = Button.builder((Component)Component.translatable((String)"gui.palamod.guardiangui.button_arbre_de_competance"), e -> {}).bounds(this.leftPos + 4, this.topPos + 139, 124, 20).build();
        guistate.put("button:button_arbre_de_competance", this.button_arbre_de_competance);
        this.addRenderableWidget((GuiEventListener)this.button_arbre_de_competance);
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }
}

