/*
 * Decompiled with CFR 0.152.
 */
package palamod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Tuple;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import palamod.init.PalamodModBlockEntities;
import palamod.init.PalamodModBlocks;
import palamod.init.PalamodModEntities;
import palamod.init.PalamodModFluidTypes;
import palamod.init.PalamodModFluids;
import palamod.init.PalamodModItems;
import palamod.init.PalamodModMenus;
import palamod.init.PalamodModMobEffects;
import palamod.init.PalamodModParticleTypes;
import palamod.init.PalamodModPotions;
import palamod.init.PalamodModSounds;
import palamod.init.PalamodModTabs;
import palamod.init.PalamodModVillagerProfessions;
import palamod.network.PalamodModVariables;
import palamod.world.features.StructureFeature;

@Mod(value="palamod")
public class PalamodMod {
    public static final Logger LOGGER = LogManager.getLogger(PalamodMod.class);
    public static final String MODID = "palamod";
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public PalamodMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        PalamodModSounds.REGISTRY.register(modEventBus);
        PalamodModBlocks.REGISTRY.register(modEventBus);
        PalamodModBlockEntities.REGISTRY.register(modEventBus);
        PalamodModItems.REGISTRY.register(modEventBus);
        PalamodModEntities.REGISTRY.register(modEventBus);
        PalamodModTabs.REGISTRY.register(modEventBus);
        PalamodModVariables.ATTACHMENT_TYPES.register(modEventBus);
        StructureFeature.REGISTRY.register(modEventBus);
        PalamodModPotions.REGISTRY.register(modEventBus);
        PalamodModMobEffects.REGISTRY.register(modEventBus);
        PalamodModMenus.REGISTRY.register(modEventBus);
        PalamodModParticleTypes.REGISTRY.register(modEventBus);
        PalamodModVillagerProfessions.PROFESSIONS.register(modEventBus);
        PalamodModFluids.REGISTRY.register(modEventBus);
        PalamodModFluidTypes.REGISTRY.register(modEventBus);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }
}

