/*
 * Decompiled with CFR 0.152.
 */
package palamod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import palamod.init.PalamodModScreens;
import palamod.network.LanguageselectionButtonMessage;
import palamod.world.inventory.LanguageselectionMenu;

public class LanguageselectionScreen
extends AbstractContainerScreen<LanguageselectionMenu>
implements PalamodModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private Button button_franais;
    private Button button_english;

    public LanguageselectionScreen(LanguageselectionMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(ResourceLocation.parse((String)"palamod:textures/screens/gui176_166.png"), this.leftPos + -1, this.topPos + 0, 0.0f, 0.0f, 176, 166, 176, 166);
        guiGraphics.blit(ResourceLocation.parse((String)"palamod:textures/screens/english_lang.png"), this.leftPos + 7, this.topPos + 31, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(ResourceLocation.parse((String)"palamod:textures/screens/french_lang.png"), this.leftPos + 6, this.topPos + 66, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.palamod.languageselection.label_select_your_language"), 31, 5, -16724788, false);
    }

    public void init() {
        super.init();
        this.button_franais = Button.builder((Component)Component.translatable((String)"gui.palamod.languageselection.button_franais"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new LanguageselectionButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            LanguageselectionButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 28, this.topPos + 64, 67, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_franais);
        this.button_english = Button.builder((Component)Component.translatable((String)"gui.palamod.languageselection.button_english"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new LanguageselectionButtonMessage(1, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            LanguageselectionButtonMessage.handleButtonAction(this.entity, 1, x, y, this.z);
        }).bounds(this.leftPos + 26, this.topPos + 29, 61, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_english);
    }
}

