/*
 * Decompiled with CFR 0.152.
 */
package com.playergames.plugin;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.mojang.brigadier.CommandDispatcher;
import com.playergames.plugin.command.SpawnTrainerCommand;
import com.playergames.plugin.command.TrainerConfigCommand;
import com.playergames.plugin.command.TrainerSkinCommand;
import com.playergames.plugin.config.TrainerConfigManager;
import com.playergames.plugin.npc.TrainerNpcService;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1297;
import net.minecraft.class_2168;

public class PGPlugin
implements DedicatedServerModInitializer {
    private static final TrainerConfigManager CONFIG = new TrainerConfigManager();
    private static final TrainerNpcService NPC_SERVICE = new TrainerNpcService(CONFIG);

    public void onInitializeServer() {
        CONFIG.load();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            SpawnTrainerCommand.register((CommandDispatcher<class_2168>)dispatcher, CONFIG, NPC_SERVICE);
            TrainerSkinCommand.register((CommandDispatcher<class_2168>)dispatcher, CONFIG, NPC_SERVICE);
            TrainerConfigCommand.register((CommandDispatcher<class_2168>)dispatcher, CONFIG, NPC_SERVICE);
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> NPC_SERVICE.handleInteraction((class_1297)player, world, hand, entity, hitResult));
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> !NPC_SERVICE.isTrainerNpc((class_1297)entity));
        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, damageSource, amount) -> !NPC_SERVICE.isTrainerNpc((class_1297)entity));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            NPC_SERVICE.setServer(server);
            NPC_SERVICE.refreshTrackedNpcs();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> NPC_SERVICE.setServer(null));
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.NORMAL, NPC_SERVICE::handleBattleVictory);
    }
}

