/*
 * Decompiled with CFR 0.152.
 */
package com.playergames.plugin.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.playergames.plugin.config.TrainerConfigManager;
import com.playergames.plugin.npc.TrainerNpcService;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public final class SpawnTrainerCommand {
    private static final String TRAINER_ID = "trainer_id";

    private SpawnTrainerCommand() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, TrainerConfigManager configManager, TrainerNpcService service) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spawntrainer").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)TRAINER_ID, (ArgumentType)StringArgumentType.string()).suggests(SpawnTrainerCommand.trainerSuggestions(configManager)).executes(context -> SpawnTrainerCommand.execute((class_2168)context.getSource(), service, StringArgumentType.getString((CommandContext)context, (String)TRAINER_ID)))));
    }

    private static int execute(class_2168 source, TrainerNpcService service, String trainerId) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        return service.spawnTrainer(player, trainerId.toLowerCase()).map(npc -> 1).orElseThrow(() -> SpawnTrainerCommand.configMissing(trainerId).create());
    }

    private static SimpleCommandExceptionType configMissing(String trainerId) {
        return new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Trainer '" + trainerId + "' is not defined.")));
    }

    private static SuggestionProvider<class_2168> trainerSuggestions(TrainerConfigManager configManager) {
        return (context, builder) -> class_2172.method_9265(configManager.getTrainerIds(), (SuggestionsBuilder)builder);
    }
}

