/*
 * Decompiled with CFR 0.152.
 */
package com.playergames.plugin.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.playergames.plugin.config.TrainerConfigManager;
import com.playergames.plugin.npc.TrainerNpcService;
import java.util.Locale;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class TrainerSkinCommand {
    private static final String TRAINER_ID = "trainer_id";
    private static final String SKIN_NAME = "name";
    private static final SimpleCommandExceptionType UNKNOWN_TRAINER = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Trainer is not defined in the YAML configuration."));

    private TrainerSkinCommand() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, TrainerConfigManager configManager, TrainerNpcService service) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trainerskin").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)TRAINER_ID, (ArgumentType)StringArgumentType.string()).suggests(TrainerSkinCommand.trainerSuggestions(configManager)).then(class_2170.method_9244((String)SKIN_NAME, (ArgumentType)StringArgumentType.greedyString()).executes(context -> TrainerSkinCommand.execute((class_2168)context.getSource(), configManager, service, StringArgumentType.getString((CommandContext)context, (String)TRAINER_ID), StringArgumentType.getString((CommandContext)context, (String)SKIN_NAME))))));
    }

    private static int execute(class_2168 source, TrainerConfigManager configManager, TrainerNpcService service, String trainerId, String rawName) throws CommandSyntaxException {
        String cleanedName;
        String skin;
        String normalizedId = trainerId.toLowerCase(Locale.ROOT);
        if (!configManager.updateSkin(normalizedId, skin = TrainerSkinCommand.interpretSkin(cleanedName = rawName.trim()))) {
            throw UNKNOWN_TRAINER.create();
        }
        service.applySkinUpdate(normalizedId, skin);
        class_5250 message = skin == null ? class_2561.method_43470((String)("Cleared custom skin for trainer '" + normalizedId + "'.")) : class_2561.method_43470((String)("Trainer '" + normalizedId + "' now uses skin '" + skin + "'."));
        source.method_9226(() -> TrainerSkinCommand.lambda$execute$2((class_2561)message), true);
        return 1;
    }

    private static String interpretSkin(String value) {
        if (value.isBlank()) {
            return null;
        }
        if (value.equalsIgnoreCase("default") || value.equalsIgnoreCase("clear") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("none")) {
            return null;
        }
        return value;
    }

    private static SuggestionProvider<class_2168> trainerSuggestions(TrainerConfigManager configManager) {
        return (context, builder) -> class_2172.method_9265(configManager.getTrainerIds(), (SuggestionsBuilder)builder);
    }

    private static /* synthetic */ class_2561 lambda$execute$2(class_2561 message) {
        return message;
    }
}

