/*
 * Decompiled with CFR 0.152.
 */
package com.playergames.plugin.config;

import com.playergames.plugin.CobblemonNpcs;
import com.playergames.plugin.config.model.ItemReward;
import com.playergames.plugin.config.model.PokemonTeamEntry;
import com.playergames.plugin.config.model.TrainerDefinition;
import com.playergames.plugin.config.model.TrainerRewards;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class TrainerConfigManager {
    private final Path configDir = FabricLoader.getInstance().getConfigDir().resolve("cobblemonnpcs");
    private final Path configPath = this.configDir.resolve("trainers.yml");
    private final Yaml yaml;
    private final Map<String, TrainerDefinition> trainers = new ConcurrentHashMap<String, TrainerDefinition>();

    public TrainerConfigManager() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setAllowDuplicateKeys(false);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setIndent(4);
        dumperOptions.setIndicatorIndent(2);
        Representer representer = new Representer(dumperOptions);
        this.yaml = new Yaml((BaseConstructor)new SafeConstructor(loaderOptions), representer, dumperOptions, loaderOptions);
    }

    public synchronized void load() {
        Object root;
        this.ensureFile();
        this.trainers.clear();
        try (BufferedReader reader = Files.newBufferedReader(this.configPath);){
            root = this.yaml.load((Reader)reader);
        }
        catch (IOException e) {
            CobblemonNpcs.LOGGER.error("Failed to read trainer config", (Throwable)e);
            return;
        }
        if (!(root instanceof Map)) {
            CobblemonNpcs.LOGGER.warn("Trainer config is empty or invalid, using defaults.");
            return;
        }
        Map mapRoot = (Map)root;
        Object trainersNode = mapRoot.get("trainers");
        if (!(trainersNode instanceof List)) {
            CobblemonNpcs.LOGGER.warn("Trainer config missing 'trainers' list.");
            return;
        }
        List entries = (List)trainersNode;
        for (Object entry : entries) {
            if (!(entry instanceof Map)) continue;
            Map entryMap = (Map)entry;
            this.parseTrainer(entryMap).ifPresent(def -> this.trainers.put(def.getTrainerId(), (TrainerDefinition)def));
        }
        CobblemonNpcs.LOGGER.info("Loaded {} trainer definitions.", (Object)this.trainers.size());
    }

    private Optional<TrainerDefinition> parseTrainer(Map<?, ?> data) {
        String trainerId = this.asString(data.get("trainer_id"));
        String trainerName = this.asString(data.get("trainer_name"));
        String battleDialogue = this.asString(data.get("battle_dialogue"));
        String defeatDialogue = this.asString(data.get("defeat_dialogue"));
        if (trainerId == null || trainerName == null || battleDialogue == null || defeatDialogue == null) {
            CobblemonNpcs.LOGGER.warn("Skipping trainer entry missing required fields: {}", data);
            return Optional.empty();
        }
        double cooldownHours = this.asNumber(data.get("cooldown_hours")).orElse(12.0);
        List<PokemonTeamEntry> teamEntries = this.parseTeam(data.get("pokemon_team"));
        if (teamEntries.isEmpty()) {
            CobblemonNpcs.LOGGER.warn("Trainer {} has no pokemon_team entries, skipping.", (Object)trainerId);
            return Optional.empty();
        }
        TrainerRewards rewards = this.parseRewards(data.get("rewards"));
        String skin = this.asString(data.get("skin"));
        return Optional.of(new TrainerDefinition(trainerId, trainerName, battleDialogue, defeatDialogue, cooldownHours, teamEntries, rewards, skin));
    }

    private List<PokemonTeamEntry> parseTeam(Object node) {
        if (!(node instanceof List)) {
            return Collections.emptyList();
        }
        List list = (List)node;
        ArrayList<PokemonTeamEntry> result = new ArrayList<PokemonTeamEntry>();
        for (Object element : list) {
            if (!(element instanceof Map)) continue;
            Map map = (Map)element;
            String species = this.asString(map.get("species"));
            int level = this.asNumber(map.get("level")).map(Double::intValue).orElse(5);
            if (species == null || species.isBlank()) continue;
            result.add(new PokemonTeamEntry(species, Math.max(1, level)));
        }
        return result;
    }

    private TrainerRewards parseRewards(Object node) {
        if (!(node instanceof Map)) {
            return TrainerRewards.empty();
        }
        Map map = (Map)node;
        ArrayList<ItemReward> items = new ArrayList<ItemReward>();
        Object itemsNode = map.get("items");
        if (itemsNode instanceof List) {
            List itemList = (List)itemsNode;
            for (Object itemObj : itemList) {
                if (!(itemObj instanceof Map)) continue;
                Map itemMap = (Map)itemObj;
                String itemIdRaw = this.asString(itemMap.get("item"));
                int count = this.asNumber(itemMap.get("count")).map(Double::intValue).orElse(1);
                if (itemIdRaw == null) continue;
                try {
                    class_2960 rl = class_2960.method_60654((String)itemIdRaw);
                    items.add(new ItemReward(rl, Math.max(1, count)));
                }
                catch (Exception ex) {
                    CobblemonNpcs.LOGGER.warn("Invalid item reward id '{}'", (Object)itemIdRaw, (Object)ex);
                }
            }
        }
        ArrayList<String> commands = new ArrayList<String>();
        Object commandNode = map.get("commands");
        if (commandNode instanceof List) {
            List cmdList = (List)commandNode;
            for (Object cmd : cmdList) {
                String literal = this.asString(cmd);
                if (literal == null || literal.isBlank()) continue;
                commands.add(literal);
            }
        }
        return new TrainerRewards(items, commands);
    }

    private Optional<Double> asNumber(Object obj) {
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return Optional.of(number.doubleValue());
        }
        if (obj instanceof String) {
            String string = (String)obj;
            try {
                return Optional.of(Double.parseDouble(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private String asString(Object obj) {
        if (obj == null) {
            return null;
        }
        String value = Objects.toString(obj, "").trim();
        return value.isEmpty() ? null : value;
    }

    private void ensureFile() {
        block8: {
            try {
                Files.createDirectories(this.configDir, new FileAttribute[0]);
                if (Files.exists(this.configPath, new LinkOption[0])) break block8;
                try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
                    writer.write(this.defaultConfig());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to prepare Cobblemon NPC config directory", e);
            }
        }
    }

    private String defaultConfig() {
        return "# Cobblemon NPC trainer configuration\n# Use the spawn and skin commands to manage NPCs after editing this file.\ntrainers:\n  - trainer_id: \"electric_master\"\n    trainer_name: \"Sora\"\n    battle_dialogue: \"Think you can withstand pure voltage?\"\n    defeat_dialogue: \"You really overpowered me!\"\n    cooldown_hours: 12\n    skin: \"Sora\"\n    pokemon_team:\n      - species: \"cobblemon:raichu\"\n        level: 55\n      - species: \"cobblemon:jolteon\"\n        level: 54\n    rewards:\n      items:\n        - item: \"minecraft:diamond\"\n          count: 2\n      commands:\n        - \"say {player} conquered {trainer}\"\n  - trainer_id: \"novice\"\n    trainer_name: \"Quinn\"\n    battle_dialogue: \"I'm still learning, but I won't hold back!\"\n    defeat_dialogue: \"I'll keep training until I win.\"\n    cooldown_hours: 1\n    pokemon_team:\n      - species: \"cobblemon:pikachu\"\n        level: 25\n";
    }

    public Map<String, TrainerDefinition> getTrainers() {
        return Collections.unmodifiableMap(this.trainers);
    }

    public List<String> getTrainerIds() {
        return this.trainers.keySet().stream().sorted().collect(Collectors.toCollection(ArrayList::new));
    }

    @Nullable
    public TrainerDefinition getTrainer(String trainerId) {
        if (trainerId == null) {
            return null;
        }
        return this.trainers.get(trainerId.toLowerCase(Locale.ROOT));
    }

    public synchronized boolean updateSkin(String trainerId, @Nullable String skinName) {
        TrainerDefinition definition = this.getTrainer(trainerId);
        if (definition == null) {
            return false;
        }
        definition.setSkinProfile(skinName);
        this.save();
        return true;
    }

    public synchronized void save() {
        List trainerList = this.trainers.values().stream().sorted(Comparator.comparing(TrainerDefinition::getTrainerId)).map(TrainerDefinition::toConfigMap).collect(Collectors.toCollection(LinkedList::new));
        LinkedHashMap<String, List> root = new LinkedHashMap<String, List>();
        root.put("trainers", trainerList);
        try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
            this.yaml.dump(root, (Writer)writer);
        }
        catch (IOException e) {
            CobblemonNpcs.LOGGER.error("Failed to save Cobblemon trainer config", (Throwable)e);
        }
    }

    public boolean isEmpty() {
        return this.trainers.isEmpty();
    }
}

