/*
 * Decompiled with CFR 0.152.
 */
package com.playergames.plugin.config.model;

import com.playergames.plugin.config.model.PokemonTeamEntry;
import com.playergames.plugin.config.model.TrainerRewards;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class TrainerDefinition {
    private final String trainerId;
    private final String trainerName;
    private final String battleDialogue;
    private final String defeatDialogue;
    private final double cooldownHours;
    private final List<PokemonTeamEntry> pokemonTeam;
    private final TrainerRewards rewards;
    private String skinProfile;

    public TrainerDefinition(String trainerId, String trainerName, String battleDialogue, String defeatDialogue, double cooldownHours, List<PokemonTeamEntry> pokemonTeam, TrainerRewards rewards, String skinProfile) {
        this.trainerId = trainerId.toLowerCase(Locale.ROOT);
        this.trainerName = trainerName;
        this.battleDialogue = battleDialogue;
        this.defeatDialogue = defeatDialogue;
        this.cooldownHours = Math.max(0.0, cooldownHours);
        this.pokemonTeam = pokemonTeam == null ? Collections.emptyList() : List.copyOf(pokemonTeam);
        this.rewards = rewards == null ? TrainerRewards.empty() : rewards;
        this.skinProfile = skinProfile;
    }

    public String getTrainerId() {
        return this.trainerId;
    }

    public String getTrainerName() {
        return this.trainerName;
    }

    public String getBattleDialogue() {
        return this.battleDialogue;
    }

    public String getDefeatDialogue() {
        return this.defeatDialogue;
    }

    public double getCooldownHours() {
        return this.cooldownHours;
    }

    public Duration getCooldownDuration() {
        long seconds = (long)Math.floor(this.cooldownHours * 3600.0);
        return seconds <= 0L ? Duration.ZERO : Duration.ofSeconds(seconds);
    }

    public List<PokemonTeamEntry> getPokemonTeam() {
        return this.pokemonTeam;
    }

    public TrainerRewards getRewards() {
        return this.rewards;
    }

    public String getSkinProfile() {
        return this.skinProfile;
    }

    public void setSkinProfile(String skinProfile) {
        this.skinProfile = skinProfile == null || skinProfile.isBlank() ? null : skinProfile;
    }

    public int getRecommendedLevel() {
        return this.pokemonTeam.stream().mapToInt(PokemonTeamEntry::getLevel).max().orElse(5);
    }

    public Map<String, Object> toConfigMap() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("trainer_id", this.trainerId);
        data.put("trainer_name", this.trainerName);
        data.put("battle_dialogue", this.battleDialogue);
        data.put("defeat_dialogue", this.defeatDialogue);
        data.put("cooldown_hours", this.cooldownHours);
        List teamList = this.pokemonTeam.stream().map(PokemonTeamEntry::toConfigMap).collect(Collectors.toCollection(LinkedList::new));
        data.put("pokemon_team", teamList);
        Map<String, Object> rewardData = this.rewards.toConfigMap();
        if (!rewardData.isEmpty()) {
            data.put("rewards", rewardData);
        }
        if (this.skinProfile != null && !this.skinProfile.isBlank()) {
            data.put("skin", this.skinProfile);
        }
        return data;
    }
}

