/*
 * Decompiled with CFR 0.152.
 */
package com.playergames.plugin.config.model;

import com.playergames.plugin.config.model.ItemReward;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TrainerRewards {
    private final List<ItemReward> items;
    private final List<String> commands;

    public TrainerRewards(List<ItemReward> items, List<String> commands) {
        this.items = items == null ? Collections.emptyList() : List.copyOf(items);
        this.commands = commands == null ? Collections.emptyList() : List.copyOf(commands);
    }

    public static TrainerRewards empty() {
        return new TrainerRewards(Collections.emptyList(), Collections.emptyList());
    }

    public List<ItemReward> getItems() {
        return this.items;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public Map<String, Object> toConfigMap() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        if (!this.items.isEmpty()) {
            data.put("items", this.items.stream().map(ItemReward::toConfigMap).collect(Collectors.toCollection(LinkedList::new)));
        }
        if (!this.commands.isEmpty()) {
            data.put("commands", new LinkedList<String>(this.commands));
        }
        return data;
    }
}

