/*
 * Decompiled with CFR 0.152.
 */
package com.playergames.plugin.cooldown;

import com.playergames.plugin.cooldown.TrainerCooldownState;
import java.time.Duration;
import java.util.UUID;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class TrainerCooldownService {
    public Duration getRemaining(MinecraftServer server, UUID playerId, String trainerId) {
        if (server == null || trainerId == null) {
            return Duration.ZERO;
        }
        long expiry = this.getState(server).getExpiry(trainerId, playerId);
        if (expiry <= 0L) {
            return Duration.ZERO;
        }
        long remaining = expiry - System.currentTimeMillis();
        if (remaining <= 0L) {
            return Duration.ZERO;
        }
        return Duration.ofMillis(remaining);
    }

    public boolean isOnCooldown(MinecraftServer server, UUID playerId, String trainerId) {
        return !this.getRemaining(server, playerId, trainerId).isZero();
    }

    public void startCooldown(MinecraftServer server, UUID playerId, String trainerId, Duration duration) {
        if (server == null || trainerId == null || duration == null) {
            return;
        }
        if (duration.isZero() || duration.isNegative()) {
            return;
        }
        long expiry = System.currentTimeMillis() + duration.toMillis();
        this.getState(server).setExpiry(trainerId, playerId, expiry);
    }

    private TrainerCooldownState getState(MinecraftServer server) {
        class_3218 overworld = server.method_30002();
        return (TrainerCooldownState)overworld.method_17983().method_17924(TrainerCooldownState.factory(), "cobblemonnpcs_trainer_cooldowns");
    }
}

