/*
 * Decompiled with CFR 0.152.
 */
package com.playergames.plugin.cooldown;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class TrainerCooldownState
extends class_18 {
    public static final String DATA_NAME = "cobblemonnpcs_trainer_cooldowns";
    private final Map<String, Map<UUID, Long>> expirations = new HashMap<String, Map<UUID, Long>>();

    public static class_18.class_8645<TrainerCooldownState> factory() {
        return new class_18.class_8645(TrainerCooldownState::new, TrainerCooldownState::load, null);
    }

    public static TrainerCooldownState load(class_2487 tag, class_7225.class_7874 provider) {
        TrainerCooldownState state = new TrainerCooldownState();
        class_2487 trainersTag = tag.method_10562("trainers");
        Set trainerKeys = trainersTag.method_10541();
        for (String trainerId : trainerKeys) {
            class_2487 trainerEntry = trainersTag.method_10562(trainerId);
            HashMap<UUID, Long> playerData = new HashMap<UUID, Long>();
            for (String playerId : trainerEntry.method_10541()) {
                try {
                    UUID uuid = UUID.fromString(playerId);
                    long expiresAt = trainerEntry.method_10537(playerId);
                    playerData.put(uuid, expiresAt);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (playerData.isEmpty()) continue;
            state.expirations.put(trainerId, playerData);
        }
        return state;
    }

    public long getExpiry(String trainerId, UUID playerId) {
        Map<UUID, Long> map = this.expirations.get(trainerId);
        if (map == null) {
            return 0L;
        }
        Long expiry = map.get(playerId);
        if (expiry == null || expiry <= 0L) {
            return 0L;
        }
        if (expiry <= System.currentTimeMillis()) {
            map.remove(playerId);
            if (map.isEmpty()) {
                this.expirations.remove(trainerId);
            }
            this.method_80();
            return 0L;
        }
        return expiry;
    }

    public void setExpiry(String trainerId, UUID playerId, long epochMillis) {
        this.expirations.computeIfAbsent(trainerId, key -> new HashMap()).put(playerId, epochMillis);
        this.method_80();
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 provider) {
        class_2487 trainersTag = new class_2487();
        this.expirations.forEach((trainerId, playerMap) -> {
            class_2487 trainerTag = new class_2487();
            playerMap.forEach((uuid, expiry) -> trainerTag.method_10544(uuid.toString(), expiry.longValue()));
            trainersTag.method_10566(trainerId, (class_2520)trainerTag);
        });
        tag.method_10566("trainers", (class_2520)trainersTag);
        return tag;
    }
}

