/*
 * Decompiled with CFR 0.152.
 */
package com.playergames.plugin.npc;

import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.dialogue.Dialogue;
import com.cobblemon.mod.common.api.dialogue.DialogueAction;
import com.cobblemon.mod.common.api.dialogue.DialogueManager;
import com.cobblemon.mod.common.api.dialogue.DialoguePage;
import com.cobblemon.mod.common.api.dialogue.DialoguePredicate;
import com.cobblemon.mod.common.api.dialogue.DialogueText;
import com.cobblemon.mod.common.api.dialogue.WrappedDialogueText;
import com.cobblemon.mod.common.api.dialogue.input.DialogueInput;
import com.cobblemon.mod.common.api.dialogue.input.DialogueOption;
import com.cobblemon.mod.common.api.dialogue.input.DialogueOptionSetInput;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.npc.NPCClass;
import com.cobblemon.mod.common.api.npc.NPCClasses;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.storage.party.NPCPartyStore;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.battles.BattleBuilder;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleStartResult;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.entity.npc.NPCBattleActor;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.playergames.plugin.CobblemonNpcs;
import com.playergames.plugin.config.TrainerConfigManager;
import com.playergames.plugin.config.model.ItemReward;
import com.playergames.plugin.config.model.PokemonTeamEntry;
import com.playergames.plugin.config.model.TrainerDefinition;
import com.playergames.plugin.cooldown.TrainerCooldownService;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Unit;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class TrainerNpcService {
    public static final String TRAINER_KEY = "cobblemonnpcs.trainer_id";
    private final TrainerConfigManager configManager;
    private final TrainerCooldownService cooldownService = new TrainerCooldownService();
    private final Map<String, Set<UUID>> trainerToNpcIds = new ConcurrentHashMap<String, Set<UUID>>();
    private final Map<UUID, String> npcTrainerLookup = new ConcurrentHashMap<UUID, String>();
    private MinecraftServer server;

    public TrainerNpcService(TrainerConfigManager configManager) {
        this.configManager = configManager;
    }

    public void setServer(@Nullable MinecraftServer server) {
        this.server = server;
    }

    public class_1269 handleInteraction(class_1297 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        if (!(player instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (hand != class_1268.field_5808 || !(entity instanceof NPCEntity)) {
            return class_1269.field_5811;
        }
        NPCEntity npc = (NPCEntity)entity;
        String trainerId = this.getTrainerId(npc);
        if (trainerId == null) {
            return class_1269.field_5811;
        }
        TrainerDefinition definition = this.configManager.getTrainer(trainerId);
        if (definition == null) {
            serverPlayer.method_43496((class_2561)class_2561.method_43470((String)("Trainer configuration missing for " + trainerId)));
            return class_1269.field_5812;
        }
        this.openDialogue(serverPlayer, npc, definition);
        return class_1269.field_5812;
    }

    public Optional<NPCEntity> spawnTrainer(class_3222 player, String trainerId) {
        TrainerDefinition definition = this.configManager.getTrainer(trainerId);
        if (definition == null) {
            return Optional.empty();
        }
        class_3218 level = player.method_51469();
        NPCEntity npc = new NPCEntity((class_1937)level);
        NPCClass npcClass = Optional.ofNullable(NPCClasses.INSTANCE.getByName("standard")).orElse(NPCClasses.INSTANCE.random());
        npc.setNpc(npcClass);
        npc.method_5808(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        npc.method_5847(player.method_5791());
        npc.method_5636(player.field_6283);
        npc.method_5665((class_2561)class_2561.method_43470((String)definition.getTrainerName()));
        this.applyTrainerProtections(npc);
        npc.initialize(definition.getRecommendedLevel());
        npc.setSkill(Integer.valueOf(3));
        NPCPartyStore party = this.buildParty(npc, definition);
        if (party != null) {
            npc.setParty(party);
        }
        this.storeTrainerId(npc, definition.getTrainerId());
        if (!level.method_8649((class_1297)npc)) {
            return Optional.empty();
        }
        this.applySkin(definition, npc);
        this.track(npc, definition.getTrainerId());
        player.method_43496((class_2561)class_2561.method_43470((String)("Spawned trainer " + definition.getTrainerName())));
        return Optional.of(npc);
    }

    private NPCPartyStore buildParty(NPCEntity npc, TrainerDefinition definition) {
        List<PokemonTeamEntry> team = definition.getPokemonTeam();
        if (team.isEmpty()) {
            return null;
        }
        NPCPartyStore party = new NPCPartyStore(npc);
        int slot = 0;
        for (PokemonTeamEntry entry : team) {
            Pokemon pokemon = this.createPokemon(entry);
            if (pokemon == null) continue;
            party.set(slot++, pokemon);
        }
        party.initialize();
        return party;
    }

    private Pokemon createPokemon(PokemonTeamEntry entry) {
        try {
            String normalized = this.normalizeIdentifier(entry.getSpecies());
            String spec = "species=\"" + normalized + "\" level=" + entry.getLevel();
            PokemonProperties properties = PokemonProperties.Companion.parse(spec);
            return properties.create();
        }
        catch (Exception ex) {
            CobblemonNpcs.LOGGER.error("Failed to create Pok\u00e9mon {} level {}", (Object)entry.getSpecies(), (Object)entry.getLevel(), (Object)ex);
            return null;
        }
    }

    private String normalizeIdentifier(String raw) {
        String cleaned = raw.trim().toLowerCase(Locale.ROOT);
        return cleaned.contains(":") ? cleaned : "cobblemon:" + cleaned;
    }

    private void applySkin(TrainerDefinition definition, NPCEntity npc) {
        String skin = definition.getSkinProfile();
        if (skin != null && !skin.isBlank()) {
            npc.loadTextureFromGameProfileName(skin);
        }
    }

    private void storeTrainerId(NPCEntity npc, String trainerId) {
        npc.method_5752().removeIf(tag -> tag.startsWith("cobblemonnpcs.trainer_id="));
        npc.method_5780("cobblemonnpcs.trainer_id=" + trainerId);
        this.npcTrainerLookup.put(npc.method_5667(), trainerId);
    }

    private void track(NPCEntity npc, String trainerId) {
        this.trainerToNpcIds.computeIfAbsent(trainerId, id -> ConcurrentHashMap.newKeySet()).add(npc.method_5667());
        this.npcTrainerLookup.put(npc.method_5667(), trainerId);
    }

    public void applySkinUpdate(String trainerId, String skinName) {
        if (this.server == null) {
            return;
        }
        Set<UUID> npcIds = this.trainerToNpcIds.get(trainerId);
        if (npcIds == null || npcIds.isEmpty()) {
            return;
        }
        Iterator<UUID> iterator = npcIds.iterator();
        while (iterator.hasNext()) {
            UUID id = iterator.next();
            NPCEntity npc = this.findNpc(id);
            if (npc == null) {
                iterator.remove();
                this.npcTrainerLookup.remove(id);
                continue;
            }
            this.applyTrainerProtections(npc);
            if (skinName == null || skinName.isBlank()) {
                npc.unloadTexture();
                continue;
            }
            npc.loadTextureFromGameProfileName(skinName);
        }
        if (npcIds.isEmpty()) {
            this.trainerToNpcIds.remove(trainerId);
        }
    }

    public void handleBattleVictory(BattleVictoryEvent event) {
        if (this.server == null) {
            return;
        }
        List<NPCBattleActor> trainerActors = event.getLosers().stream().filter(NPCBattleActor.class::isInstance).map(NPCBattleActor.class::cast).filter(actor -> this.getTrainerId(actor.getNpc()) != null).toList();
        if (trainerActors.isEmpty()) {
            return;
        }
        HashSet<CallSite> processed = new HashSet<CallSite>();
        for (BattleActor winner : event.getWinners()) {
            PlayerBattleActor playerActor;
            class_3222 player;
            if (!(winner instanceof PlayerBattleActor) || (player = (playerActor = (PlayerBattleActor)winner).getEntity()) == null) continue;
            for (NPCBattleActor npcActor : trainerActors) {
                TrainerDefinition definition;
                String key;
                NPCEntity npc = npcActor.getNpc();
                String trainerId = this.getTrainerId(npc);
                if (trainerId == null || !processed.add((CallSite)((Object)(key = trainerId + "_" + String.valueOf(player.method_5667())))) || (definition = this.configManager.getTrainer(trainerId)) == null) continue;
                this.applyVictoryRewards(player, definition);
            }
        }
    }

    private void applyVictoryRewards(class_3222 player, TrainerDefinition definition) {
        this.giveItems(player, definition);
        this.runCommands(player, definition);
        Duration duration = definition.getCooldownDuration();
        if (!duration.isZero()) {
            this.cooldownService.startCooldown(player.field_13995, player.method_5667(), definition.getTrainerId(), duration);
        }
        if (definition.getDefeatDialogue() != null && !definition.getDefeatDialogue().isBlank()) {
            player.method_43496((class_2561)class_2561.method_43470((String)definition.getDefeatDialogue()));
        }
    }

    private void giveItems(class_3222 player, TrainerDefinition definition) {
        for (ItemReward reward : definition.getRewards().getItems()) {
            Optional item = class_7923.field_41178.method_17966(reward.getItemId());
            if (item.isEmpty()) {
                CobblemonNpcs.LOGGER.warn("Unknown reward item {}", (Object)reward.getItemId());
                continue;
            }
            class_1799 stack = new class_1799((class_1935)item.get(), Math.max(1, reward.getCount()));
            if (player.method_7270(stack.method_7972())) continue;
            player.method_7328(stack, false);
        }
    }

    private void runCommands(class_3222 player, TrainerDefinition definition) {
        if (definition.getRewards().getCommands().isEmpty()) {
            return;
        }
        class_2168 source = player.method_5671().method_9217().method_9206(4);
        for (String raw : definition.getRewards().getCommands()) {
            String parsed = raw.replace("{player}", player.method_7334().getName()).replace("{trainer}", definition.getTrainerName());
            player.field_13995.method_3734().method_44252(source, parsed);
        }
    }

    private void openDialogue(class_3222 player, NPCEntity npc, TrainerDefinition definition) {
        Duration remaining = this.cooldownService.getRemaining(player.field_13995, player.method_5667(), definition.getTrainerId());
        DialogueOptionSetInput input = new DialogueOptionSetInput(new ArrayList(), null, false);
        input.getOptions().add(this.createBattleOption(player, npc, definition, remaining));
        input.getOptions().add(new DialogueOption((DialogueText)new WrappedDialogueText(class_2561.method_43470((String)"Close")), "close", (dialogue, value) -> dialogue.close(), dialogue -> true, dialogue -> true));
        List<class_5250> lines = this.splitLines(definition.getBattleDialogue());
        DialoguePage page = DialoguePage.Companion.of("intro", definition.getTrainerName(), lines, null, (DialogueInput)input);
        Dialogue dialogue2 = new Dialogue(List.of(page), Dialogue.Companion.getDEFAULT_BACKGROUND(), (active, value) -> active.close(), Collections.emptyMap(), (active, value) -> {});
        DialogueManager.startDialogue((class_3222)player, (NPCEntity)npc, (Dialogue)dialogue2);
    }

    private DialogueOption createBattleOption(class_3222 player, NPCEntity npc, TrainerDefinition definition, Duration remaining) {
        DialogueText text = this.buildBattleText(remaining);
        DialogueAction action = (dialogue, value) -> {
            Duration current = this.cooldownService.getRemaining(player.field_13995, player.method_5667(), definition.getTrainerId());
            if (!current.isZero()) {
                player.method_43496((class_2561)class_2561.method_43470((String)("Trainer is resting for " + this.formatDuration(current))));
                return;
            }
            BattleStartResult result = BattleBuilder.INSTANCE.pvn(player, npc, null, BattleFormat.Companion.getGEN_9_SINGLES(), false, false, (PartyStore)PlayerExtensionsKt.party((class_3222)player));
            result.ifSuccessful(battle -> {
                dialogue.close();
                return Unit.INSTANCE;
            });
            result.ifErrored(errors -> {
                errors.sendTo((class_1297)player, component -> component);
                return Unit.INSTANCE;
            });
        };
        DialoguePredicate selectable = dialogue -> this.cooldownService.getRemaining(player.field_13995, player.method_5667(), definition.getTrainerId()).isZero();
        return new DialogueOption(text, "battle", action, dialogue -> true, selectable);
    }

    private DialogueText buildBattleText(Duration remaining) {
        String label = remaining.isZero() ? "Battle!" : "Battle! (" + this.formatDuration(remaining) + ")";
        return new WrappedDialogueText(class_2561.method_43470((String)label));
    }

    private List<class_5250> splitLines(String text) {
        if (text == null || text.isBlank()) {
            return List.of(class_2561.method_43473());
        }
        String[] parts = text.split("\\R");
        ArrayList<class_5250> lines = new ArrayList<class_5250>(parts.length);
        for (String part : parts) {
            lines.add(class_2561.method_43470((String)part.trim()));
        }
        return lines;
    }

    public String getTrainerId(NPCEntity npc) {
        for (String tag : npc.method_5752()) {
            String id;
            if (!tag.startsWith("cobblemonnpcs.trainer_id=") || (id = tag.substring("cobblemonnpcs.trainer_id=".length())).isBlank()) continue;
            return id;
        }
        return this.npcTrainerLookup.get(npc.method_5667());
    }

    public boolean isTrainerNpc(class_1297 entity) {
        if (!(entity instanceof NPCEntity)) {
            return false;
        }
        NPCEntity npc = (NPCEntity)entity;
        return this.getTrainerId(npc) != null;
    }

    public void refreshTrackedNpcs() {
        if (this.server == null) {
            return;
        }
        this.trainerToNpcIds.forEach((trainerId, npcIds) -> {
            TrainerDefinition definition = this.configManager.getTrainer((String)trainerId);
            Iterator iterator = npcIds.iterator();
            while (iterator.hasNext()) {
                UUID npcId = (UUID)iterator.next();
                NPCEntity npc = this.findNpc(npcId);
                if (npc == null) {
                    iterator.remove();
                    this.npcTrainerLookup.remove(npcId);
                    continue;
                }
                this.applyTrainerProtections(npc);
                if (definition == null) continue;
                npc.method_5665((class_2561)class_2561.method_43470((String)definition.getTrainerName()));
                this.applySkin(definition, npc);
            }
            if (npcIds.isEmpty()) {
                this.trainerToNpcIds.remove(trainerId, npcIds);
            }
        });
    }

    private void applyTrainerProtections(NPCEntity npc) {
        npc.method_5684(true);
        npc.method_5971();
        npc.method_5977(true);
        npc.setMovable(Boolean.valueOf(false));
        npc.setLeashable(Boolean.valueOf(false));
        npc.setAllowProjectileHits(Boolean.valueOf(false));
        npc.method_6033(npc.method_6063());
    }

    private NPCEntity findNpc(UUID id) {
        if (this.server == null) {
            return null;
        }
        for (class_3218 level : this.server.method_3738()) {
            NPCEntity npc;
            class_1297 entity = level.method_14190(id);
            if (!(entity instanceof NPCEntity) || !(npc = (NPCEntity)entity).method_5805()) continue;
            return npc;
        }
        return null;
    }

    private String formatDuration(Duration duration) {
        long hours = duration.toHours();
        long minutes = duration.toMinutesPart();
        long seconds = duration.toSecondsPart();
        StringBuilder builder = new StringBuilder();
        if (hours > 0L) {
            builder.append(hours).append("h");
        }
        if (minutes > 0L) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(minutes).append("m");
        }
        if (builder.length() == 0) {
            builder.append(seconds).append("s");
        }
        return builder.toString();
    }
}

