package net.gamemode3.moveon.mixin;

import net.minecraft.class_1688;
import net.minecraft.class_2241;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2442;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1688.class)
public class AbstractMinecartEntityMixin {

    @Inject(method="getLaunchDirection", at=@At("HEAD"), cancellable=true)
    public void getLaunchDirection(class_2338 railPos, CallbackInfoReturnable<class_243> cir) {
        class_1688 self = (class_1688)(Object)this;
        class_2680 blockState = self.method_37908().method_8320(railPos);
        if (blockState.method_26204() instanceof class_2442 && blockState.method_11654(class_2442.field_11364)) {
            class_2768 railShape = blockState.method_11654(((class_2241)blockState.method_26204()).method_9474());
            if (railShape == class_2768.field_12674) {
                if (self.method_18803(railPos.method_10067())) {
                    cir.setReturnValue(new class_243(1.0, 0.0, 0.0));
                    return;
                }

                if (self.method_18803(railPos.method_10078())) {
                    cir.setReturnValue(new class_243(-1.0, 0.0, 0.0));
                    return;
                }
            } else if (railShape == class_2768.field_12665) {
                if (self.method_18803(railPos.method_10095())) {
                    cir.setReturnValue(new class_243(0.0, 0.0, 1.0));
                    return;
                }

                if (self.method_18803(railPos.method_10072())) {
                    cir.setReturnValue(new class_243(0.0, 0.0, -1.0));
                    return;
                }
            }
        }
        cir.setReturnValue(class_243.field_1353);
    }

    @Inject(method="areMinecartImprovementsEnabled", at=@At("HEAD"), cancellable=true)
    private static void areMinecartImprovementsEnabled(CallbackInfoReturnable<Boolean> cir) {
        // Disable minecart improvements to prevent issues with the custom launch direction
        cir.setReturnValue(true);
    }
}

