package net.gamemode3.moveon.mixin;

import net.gamemode3.moveon.block.ModBlocks;
import net.minecraft.class_1688;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2442;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_9879;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_9879.class)
public class ExperimentalMinecartControllerMixin {
    @Inject(method="getMaxSpeed", at = @At("HEAD"), cancellable = true)
    public void getMaxSpeed(class_3218 world, CallbackInfoReturnable<Double> cir) {
        class_9879 self = (class_9879) (Object) this;
        class_1688 minecart = ((MinecartControllerAccessor) self).getMinecart();

        // Bypass the gamerule check (because the gamerule shit is annoying)
        cir.setReturnValue(minecart.method_5799() ? 0.025 : 2);
    }

    @Inject(method = "decelerateFromPoweredRail", at = @At("HEAD"), cancellable = true)
    private void decelerateFromPoweredRail(class_243 velocity, class_2680 railState, CallbackInfoReturnable<class_243> cir) {
        boolean onPoweredRail = railState.method_27852(class_2246.field_10425) || railState.method_27852(ModBlocks.LIGHTLY_POWERED_RAIL);

        if (onPoweredRail && !(Boolean)railState.method_11654(class_2442.field_11364)) {
            cir.setReturnValue(velocity.method_1033() < 0.03 ? class_243.field_1353 : velocity.method_1021(0.5));
        } else {
            cir.setReturnValue(velocity);
        }
    }

    @Inject(method="accelerateFromPoweredRail", at = @At("HEAD"), cancellable = true)
    private void accelerateFromPoweredRail(class_243 velocity, class_2338 railPos, class_2680 railState, CallbackInfoReturnable<class_243> cir) {
        class_9879 self = (class_9879) (Object) this;
        class_1688 minecart = ((MinecartControllerAccessor) self).getMinecart();
        boolean onPoweredRail = railState.method_27852(class_2246.field_10425) || railState.method_27852(ModBlocks.LIGHTLY_POWERED_RAIL);

        if (onPoweredRail && railState.method_11654(class_2442.field_11364)) {

            double velocityLength = velocity.method_1033();

            if (velocity.method_1033() > 0.01) {

                double acceleration = 0.09; // Lightly powered rail acceleration
                double maxSpeed = 0.6; // Lightly powered rail max speed
                if (railState.method_27852(class_2246.field_10425)) {
                    acceleration = 0.15; // Booster rail acceleration
                    maxSpeed = 1.0; // Booster rail max speed
                }

                if (velocityLength < maxSpeed) {
                    velocityLength += acceleration;
                    if (velocityLength > maxSpeed) velocityLength = maxSpeed;
                }

                if (velocityLength > maxSpeed) {
                    double deceleration = 0.01;
                    velocityLength -= deceleration;
                    if (velocityLength < maxSpeed) velocityLength = maxSpeed;
                }

                cir.setReturnValue(velocity.method_1029().method_1021(velocityLength));
            } else {
                class_243 vec3d = minecart.method_61563(railPos);
                cir.setReturnValue(vec3d.method_1027() <= 0.0 ? velocity : vec3d.method_1021(velocity.method_1033() + 0.2));
            }
        } else {
            cir.setReturnValue(velocity);
        }
    }
}
