/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.impl.ComponentManager;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.tag.IafEntityTags;
import com.iafenvoy.iceandfire.util.attachment.IafEntityAttachment;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ItemLike;

public class ChickenData
implements IafEntityAttachment<LivingEntity> {
    public static final Codec<ChickenData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("timeUntilNextEgg").forGetter(ChickenData::getTimeUntilNextEgg)).apply((Applicative)i, ChickenData::new));
    private int timeUntilNextEgg = -1;

    public ChickenData() {
    }

    private ChickenData(int timeUntilNextEgg) {
        this.timeUntilNextEgg = timeUntilNextEgg;
    }

    @Override
    public void tick(LivingEntity entity) {
        if (!((Boolean)IafCommonConfig.INSTANCE.cockatrice.chickensLayRottenEggs.getValue()).booleanValue() || entity.level().isClientSide() || !entity.getType().is(IafEntityTags.CHICKENS) || entity.isBaby()) {
            return;
        }
        if (this.timeUntilNextEgg == -1) {
            this.timeUntilNextEgg = this.createDefaultTime(entity.getRandom());
        }
        if (this.timeUntilNextEgg == 0) {
            if (entity.tickCount > 30 && entity.getRandom().nextDouble() < (Double)IafCommonConfig.INSTANCE.cockatrice.eggChance.getValue()) {
                entity.playSound(SoundEvents.CHICKEN_HURT, 2.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
                entity.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
                entity.spawnAtLocation((ItemLike)IafItems.ROTTEN_EGG.get(), 1);
            }
            this.timeUntilNextEgg = -1;
        } else {
            --this.timeUntilNextEgg;
        }
    }

    public void setTime(int timeUntilNextEgg) {
        this.timeUntilNextEgg = timeUntilNextEgg;
    }

    public int getTimeUntilNextEgg() {
        return this.timeUntilNextEgg;
    }

    private int createDefaultTime(RandomSource random) {
        return random.nextInt(6000) + 6000;
    }

    public static ChickenData get(LivingEntity living) {
        return ComponentManager.getChickenData(living);
    }
}

