/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.util.BlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.IDeadMob;
import com.iafenvoy.iceandfire.item.DragonEggItem;
import com.iafenvoy.iceandfire.item.block.entity.EggInIceBlockEntity;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafDragonColors;
import com.iafenvoy.iceandfire.registry.IafDragonTypes;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.object.BlockUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DragonEggEntity
extends LivingEntity
implements BlacklistedFromStatues,
IDeadMob {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.defineId(DragonEggEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final Map<DragonType, EggTicker> TICKERS = new LinkedHashMap<DragonType, EggTicker>();
    private static final EntityDataAccessor<String> DRAGON_TYPE = SynchedEntityData.defineId(DragonEggEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> DRAGON_AGE = SynchedEntityData.defineId(DragonEggEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> LOCATION_VALID = SynchedEntityData.defineId(DragonEggEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public DragonEggEntity(EntityType<DragonEggEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("Color", this.getEggType().getName());
        tag.putInt("DragonAge", this.getDragonAge());
        try {
            if (this.getOwnerId() == null) {
                tag.putString("OwnerUUID", "");
            } else {
                tag.putString("OwnerUUID", this.getOwnerId().toString());
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.error("An error occurred while trying to read the NBT data of a dragon egg", (Throwable)e);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        String s;
        super.readAdditionalSaveData(tag);
        this.setEggType(DragonColor.getById(tag.getString("Color")));
        this.setDragonAge(tag.getInt("DragonAge"));
        if (tag.contains("OwnerUUID", 8)) {
            s = tag.getString("OwnerUUID");
        } else {
            String s1 = tag.getString("Owner");
            UUID converedUUID = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s1);
            String string = s = converedUUID == null ? s1 : converedUUID.toString();
        }
        if (!s.isEmpty()) {
            this.setOwnerId(UUID.fromString(s));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DRAGON_TYPE, (Object)IafDragonColors.RED.toString());
        builder.define(DRAGON_AGE, (Object)0);
        builder.define(OWNER_UNIQUE_ID, Optional.empty());
        builder.define(LOCATION_VALID, (Object)false);
    }

    public boolean isInvulnerableTo(DamageSource i) {
        return i.getEntity() != null && super.isInvulnerableTo(i);
    }

    public DragonColor getEggType() {
        return DragonColor.getById((String)this.getEntityData().get(DRAGON_TYPE));
    }

    public void setEggType(DragonColor color) {
        this.getEntityData().set(DRAGON_TYPE, (Object)color.getName());
    }

    public int getDragonAge() {
        return (Integer)this.getEntityData().get(DRAGON_AGE);
    }

    public void setDragonAge(int i) {
        this.getEntityData().set(DRAGON_AGE, (Object)i);
    }

    public UUID getOwnerId() {
        return ((Optional)this.entityData.get(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(UUID uuid) {
        this.entityData.set(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public boolean isLocationValid() {
        return (Boolean)this.entityData.get(LOCATION_VALID);
    }

    public void setLocationValid(boolean valid) {
        this.entityData.set(LOCATION_VALID, (Object)valid);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && !this.isRemoved()) {
            this.setAirSupply(200);
            this.updateEggCondition();
        }
    }

    public void updateEggCondition() {
        boolean hatched;
        DragonType dragonType = this.getEggType().getType();
        EggTicker ticker = TICKERS.get(dragonType);
        boolean bl = hatched = this.getDragonAge() > (Integer)IafCommonConfig.INSTANCE.dragon.eggBornTime.getValue();
        if (ticker != null) {
            this.setLocationValid(ticker.tick(this, this.level(), this.blockPosition(), hatched));
        }
        if (hatched) {
            this.level().setBlockAndUpdate(this.blockPosition(), Blocks.AIR.defaultBlockState());
            DragonBaseEntity dragon = dragonType.createEntity(this.level());
            assert (dragon != null);
            dragon.setVariant(this.getEggType().getName());
            dragon.setGender(this.getRandom().nextBoolean());
            dragon.setPos((double)this.blockPosition().getX() + 0.5, this.blockPosition().getY() + 1, (double)this.blockPosition().getZ() + 0.5);
            dragon.setHunger(50);
            if (!this.level().isClientSide()) {
                this.level().addFreshEntity((Entity)dragon);
            }
            if (this.hasCustomName()) {
                dragon.setCustomName(this.getCustomName());
            }
            dragon.setTame(true, true);
            dragon.setOwnerUUID(this.getOwnerId());
            this.level().playLocalSound(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ(), (SoundEvent)IafSounds.EGG_HATCH.get(), this.getSoundSource(), 2.5f, 1.0f, false);
            this.discard();
        }
    }

    public SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return null;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return ImmutableList.of();
    }

    public ItemStack getItemBySlot(EquipmentSlot slotIn) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
    }

    public boolean hurt(DamageSource var1, float var2) {
        if (var1.is(DamageTypeTags.IS_FIRE) && this.getEggType().getType() == IafDragonTypes.FIRE) {
            return false;
        }
        if (!(this.level().isClientSide || var1.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || this.isRemoved())) {
            this.spawnAtLocation((ItemLike)this.getItem().getItem(), 1);
        }
        this.remove(Entity.RemovalReason.KILLED);
        return true;
    }

    private ItemStack getItem() {
        return new ItemStack((ItemLike)DragonEggItem.EGGS.getOrDefault(this.getEggType(), Items.AIR));
    }

    public boolean isPushable() {
        return false;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    protected void doPush(Entity entity) {
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public void onPlayerPlace(Player player) {
        this.setOwnerId(player.getUUID());
    }

    @Override
    public boolean isMobDead() {
        return true;
    }

    public static void register(DragonType type, EggTicker ticker) {
        TICKERS.put(type, ticker);
    }

    static {
        DragonEggEntity.register(IafDragonTypes.FIRE, (entity, world, pos, hatched) -> {
            boolean valid = BlockUtil.isBurning((BlockState)world.getBlockState(pos));
            if (valid) {
                entity.setDragonAge(entity.getDragonAge() + 1);
            }
            if (hatched) {
                world.playLocalSound(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ(), SoundEvents.FIRE_EXTINGUISH, entity.getSoundSource(), 2.5f, 1.0f, false);
            }
            return valid;
        });
        DragonEggEntity.register(IafDragonTypes.ICE, (entity, world, pos, hatched) -> {
            BlockState state = world.getBlockState(pos);
            if (state.is(Blocks.WATER) && entity.getRandom().nextInt(500) == 0) {
                world.setBlockAndUpdate(pos, ((Block)IafBlocks.EGG_IN_ICE.get()).defaultBlockState());
                world.playLocalSound(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ(), SoundEvents.GLASS_BREAK, entity.getSoundSource(), 2.5f, 1.0f, false);
                BlockEntity patt0$temp = world.getBlockEntity(pos);
                if (patt0$temp instanceof EggInIceBlockEntity) {
                    EggInIceBlockEntity eggInIce = (EggInIceBlockEntity)patt0$temp;
                    eggInIce.type = entity.getEggType();
                    eggInIce.ownerUUID = entity.getOwnerId();
                }
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
            return false;
        });
        DragonEggEntity.register(IafDragonTypes.LIGHTNING, (entity, world, pos, hatched) -> {
            boolean valid;
            boolean isRainingAt = world.isRainingAt(pos) || world.isRainingAt(BlockPos.containing((double)entity.getX(), (double)(entity.getY() + (double)entity.getBbHeight()), (double)entity.getZ()));
            boolean bl = valid = world.canSeeSky(pos.above()) && isRainingAt;
            if (valid) {
                entity.setDragonAge(entity.getDragonAge() + 1);
            }
            if (hatched) {
                LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(world);
                assert (bolt != null);
                bolt.setPos(entity.getX(), entity.getY(), entity.getZ());
                bolt.setVisualOnly(true);
                if (!world.isClientSide) {
                    world.addFreshEntity((Entity)bolt);
                }
                world.playLocalSound(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, entity.getSoundSource(), 2.5f, 1.0f, false);
            }
            return valid;
        });
    }

    @FunctionalInterface
    public static interface EggTicker {
        public boolean tick(DragonEggEntity var1, Level var2, BlockPos var3, boolean var4);
    }
}

