/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.registry.IafParticles;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;

public class DreadLichSkullEntity
extends AbstractArrow {
    public DreadLichSkullEntity(EntityType<? extends AbstractArrow> type, Level worldIn) {
        super(type, worldIn);
        this.setBaseDamage(6.0);
    }

    public DreadLichSkullEntity(EntityType<? extends AbstractArrow> type, Level worldIn, double x, double y, double z) {
        this(type, worldIn);
        this.setPos(x, y, z);
        this.setBaseDamage(6.0);
    }

    public DreadLichSkullEntity(EntityType<? extends AbstractArrow> type, Level worldIn, LivingEntity shooter, double x, double y, double z) {
        super(type, worldIn);
        this.setOwner((Entity)shooter);
        this.setBaseDamage(6.0);
        this.setPosRaw(x, y, z);
    }

    public DreadLichSkullEntity(EntityType<? extends AbstractArrow> type, Level worldIn, LivingEntity shooter, double dmg) {
        super(type, worldIn);
        this.setOwner((Entity)shooter);
        this.setBaseDamage(dmg);
    }

    public boolean isInWater() {
        return false;
    }

    public void tick() {
        Entity shootingEntity;
        float sqrt = Mth.sqrt((float)((float)(this.getDeltaMovement().x * this.getDeltaMovement().x + this.getDeltaMovement().z * this.getDeltaMovement().z)));
        if ((sqrt < 0.1f || this.horizontalCollision || this.verticalCollision || this.inGround) && this.tickCount > 5) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if ((shootingEntity = this.getOwner()) instanceof Mob && ((Mob)shootingEntity).getTarget() != null) {
            LivingEntity target = ((Mob)shootingEntity).getTarget();
            double minusX = target.getX() - this.getX();
            double minusY = target.getY() - this.getY();
            double minusZ = target.getZ() - this.getZ();
            double speed = 0.15;
            this.setDeltaMovement(this.getDeltaMovement().add(minusX * speed * 0.1, minusY * speed * 0.1, minusZ * speed * 0.1));
        }
        if (shootingEntity instanceof Player) {
            Player player = (Player)shootingEntity;
            LivingEntity target = player.getKillCredit();
            if (target == null || !target.isAlive()) {
                double d0 = 10.0;
                List list = this.level().getEntities(shootingEntity, new AABB(this.getX(), this.getY(), this.getZ(), this.getX() + 1.0, this.getY() + 1.0, this.getZ() + 1.0).inflate(d0, 10.0, d0), EntitySelector.ENTITY_STILL_ALIVE);
                LivingEntity closest = null;
                if (!list.isEmpty()) {
                    for (Entity e : list) {
                        if (!(e instanceof LivingEntity) || e.getUUID().equals(shootingEntity.getUUID()) || !(e instanceof Enemy) || closest != null && !(closest.distanceTo(shootingEntity) > e.distanceTo(shootingEntity))) continue;
                        closest = (LivingEntity)e;
                    }
                }
                target = closest;
            }
            if (target != null && target.isAlive()) {
                double minusX = target.getX() - this.getX();
                double minusY = target.getY() + (double)target.getEyeHeight() - this.getY();
                double minusZ = target.getZ() - this.getZ();
                double speed = 0.25 * Math.min((double)this.distanceTo((Entity)target), 10.0) / 10.0;
                this.setDeltaMovement(this.getDeltaMovement().add((Math.signum(minusX) * 0.5 - this.getDeltaMovement().x) * (double)0.1f, (Math.signum(minusY) * 0.5 - this.getDeltaMovement().y) * (double)0.1f, (Math.signum(minusZ) * 0.5 - this.getDeltaMovement().z) * (double)0.1f));
                this.setYRot((float)(Mth.atan2((double)this.getDeltaMovement().x, (double)this.getDeltaMovement().z) * 57.29577951308232));
                this.setXRot((float)(Mth.atan2((double)this.getDeltaMovement().y, (double)sqrt) * 57.29577951308232));
            }
        }
        double d0 = 0.0;
        double d1 = 0.01;
        double d2 = 0.0;
        double x = this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth();
        double y = this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()) - (double)this.getBbHeight();
        double z = this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth();
        float f = (this.getBbWidth() + this.getBbHeight() + this.getBbWidth()) * 0.333f + 0.5f;
        if (this.particleDistSq(x, y, z) < (double)(f * f)) {
            this.level().addParticle((ParticleOptions)IafParticles.DREAD_TORCH.get(), x, y + 0.5, z, d0, d1, d2);
        }
        super.tick();
    }

    public double particleDistSq(double toX, double toY, double toZ) {
        double d0 = this.getX() - toX;
        double d1 = this.getY() - toY;
        double d2 = this.getZ() - toZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void playSound(SoundEvent soundIn, float volume, float pitch) {
        if (!this.isSilent() && soundIn != SoundEvents.ARROW_HIT && soundIn != SoundEvents.ARROW_HIT_PLAYER) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), soundIn, this.getSoundSource(), volume, pitch);
        }
    }

    protected void onHitEntity(EntityHitResult raytraceResultIn) {
        Entity entity = raytraceResultIn.getEntity();
        Entity shootingEntity = this.getOwner();
        if (entity != null && shootingEntity != null && entity.isAlliedTo(shootingEntity)) {
            return;
        }
        super.onHitEntity(raytraceResultIn);
    }

    protected void doPostHurtEffects(LivingEntity living) {
        super.doPostHurtEffects(living);
        Entity shootingEntity = this.getOwner();
        if (living != null && (shootingEntity == null || !living.is(shootingEntity)) && living instanceof Player) {
            this.damageShield((Player)living, (float)this.getBaseDamage());
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected void damageShield(Player player, float damage) {
        if (damage >= 3.0f && player.getUseItem().getItem() instanceof ShieldItem) {
            int i = 1 + Mth.floor((float)damage);
            player.getUseItem().hurtAndBreak(i, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            if (player.getUseItem().isEmpty()) {
                InteractionHand hand = player.getUsedItemHand();
                player.stopUsingItem();
                this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
            }
        }
    }

    public boolean isNoGravity() {
        return true;
    }
}

