/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.SeaSerpentType;
import com.iafenvoy.iceandfire.entity.MultipartPartEntity;
import com.iafenvoy.iceandfire.entity.SeaSerpentBubblesEntity;
import com.iafenvoy.iceandfire.entity.SlowPartEntity;
import com.iafenvoy.iceandfire.entity.ai.FlyingAITargetGoal;
import com.iafenvoy.iceandfire.entity.ai.SeaSerpentAIAttackMeleeGoal;
import com.iafenvoy.iceandfire.entity.ai.SeaSerpentAIGetInWaterGoal;
import com.iafenvoy.iceandfire.entity.ai.SeaSerpentAIJumpGoal;
import com.iafenvoy.iceandfire.entity.ai.SeaSerpentAIMeleeJumpGoal;
import com.iafenvoy.iceandfire.entity.ai.SeaSerpentAIRandomSwimmingGoal;
import com.iafenvoy.iceandfire.entity.ai.SeaSerpentPathNavigatorGoal;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IMultipartEntity;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.IafEntityUtil;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafRegistries;
import com.iafenvoy.iceandfire.registry.IafSeaSerpentTypes;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.util.RandomHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SeaSerpentEntity
extends Animal
implements IAnimatedEntity,
IMultipartEntity,
IVillagerFear,
IAnimalFear,
IHasCustomizableAttributes {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)15);
    public static final Animation ANIMATION_ROAR = Animation.create((int)40);
    public static final int TIME_BETWEEN_ROARS = 300;
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(SeaSerpentEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.defineId(SeaSerpentEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> JUMPING = SynchedEntityData.defineId(SeaSerpentEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BREATHING = SynchedEntityData.defineId(SeaSerpentEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ANCIENT = SynchedEntityData.defineId(SeaSerpentEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final float[] tailYaw = new float[5];
    private final float[] prevTailYaw = new float[5];
    private final float[] tailPitch = new float[5];
    private final float[] prevTailPitch = new float[5];
    public int swimCycle;
    public float jumpProgress = 0.0f;
    public float wantJumpProgress = 0.0f;
    public float jumpRot = 0.0f;
    public float prevJumpRot = 0.0f;
    public float breathProgress = 0.0f;
    public boolean attackDecision = false;
    public int jumpCooldown = 0;
    private int animationTick;
    private Animation currentAnimation;
    private SlowPartEntity[] segments = new SlowPartEntity[9];
    private float lastScale;
    private boolean isLandNavigator;
    private boolean changedSwimBehavior = false;
    private int ticksSinceRoar = 0;
    private boolean isBreathing;

    public SeaSerpentEntity(EntityType<SeaSerpentEntity> t, Level worldIn) {
        super(t, worldIn);
        this.switchNavigator(false);
        this.noCulling = true;
        this.lastScale = 0.0f;
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public static boolean isWaterBlock(Level world, BlockPos pos) {
        return world.getFluidState(pos).is(FluidTags.WATER);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ((Double)IafCommonConfig.INSTANCE.seaSerpent.baseHealth.getValue()).doubleValue()).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FOLLOW_RANGE, (double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue())).add(Attributes.ARMOR, 3.0);
    }

    private static boolean canBreak(Block block) {
        return block instanceof CropBlock || block instanceof SaplingBlock || block instanceof FlowerBlock || block == Blocks.DEAD_BUSH || block == Blocks.LILY_PAD || block == Blocks.RED_MUSHROOM || block == Blocks.BROWN_MUSHROOM || block == Blocks.NETHER_WART || block == Blocks.TALL_GRASS;
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SeaSerpentAIGetInWaterGoal(this));
        this.goalSelector.addGoal(1, (Goal)new SeaSerpentAIMeleeJumpGoal(this));
        this.goalSelector.addGoal(1, (Goal)new SeaSerpentAIAttackMeleeGoal(this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new SeaSerpentAIRandomSwimmingGoal((PathfinderMob)this, 1.0, 2));
        this.goalSelector.addGoal(3, (Goal)new SeaSerpentAIJumpGoal(this, 4));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{MultipartPartEntity.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new FlyingAITargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 150, false, false, entity1 -> !(entity1 instanceof SeaSerpentEntity) && DragonUtils.isAlive(entity1) && entity1.isInWaterOrBubble()));
        this.targetSelector.addGoal(3, new FlyingAITargetGoal<Player>((Mob)this, Player.class, 0, false, false, entity -> !(entity instanceof SeaSerpentEntity) && DragonUtils.isAlive(entity)));
    }

    public int getBaseExperienceReward() {
        return this.isAncient() ? 30 : 15;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public void pushEntities() {
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards((double)0.2f, 0.0, (double)0.2f));
        entities.stream().filter(entity -> !(entity instanceof MultipartPartEntity) && entity.isPushable()).forEach(entity -> entity.push((Entity)this));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigation((Mob)this, this.level());
            this.navigation.setCanFloat(true);
            this.isLandNavigator = true;
        } else {
            this.moveControl = new SwimmingMoveHelper(this);
            this.navigation = new SeaSerpentPathNavigatorGoal((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    public boolean isDirectPathBetweenPoints(BlockPos pos) {
        Vec3 vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 bector3d1 = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        return this.level().clip(new ClipContext(vector3d, bector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    @Override
    public void setConfigurableAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)IafCommonConfig.INSTANCE.seaSerpent.baseHealth.getValue()).doubleValue());
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue((double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue()));
        this.updateAttributes();
    }

    public void updateScale(float scale) {
        this.segments = new SlowPartEntity[9];
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] == null || this.segments[i].isRemoved()) {
                this.segments[i] = i > 3 ? new SlowPartEntity((Entity)this, 0.5f * (float)(i - 3), 180.0f, 0.0f, 0.5f, 0.5f, 1.0f) : new SlowPartEntity((Entity)this, -0.4f * (float)(i + 1), 180.0f, 0.0f, 0.45f, 0.4f, 1.0f);
                this.level().addFreshEntity((Entity)this.segments[i]);
            }
            this.segments[i].updateScale(scale);
        }
    }

    public void onUpdateParts() {
        if (this.isRemoved()) {
            return;
        }
        for (SlowPartEntity entity : this.segments) {
            entity.copyPosition((Entity)this);
            IafEntityUtil.updatePart(entity, (LivingEntity)this);
        }
    }

    private void removeParts() {
        for (SlowPartEntity entity : this.segments) {
            if (entity == null) continue;
            entity.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public void remove(Entity.RemovalReason reason) {
        this.removeParts();
        super.remove(reason);
    }

    public EntityDimensions getDimensions(Pose poseIn) {
        return this.getType().getDimensions().scale(this.getAgeScale());
    }

    public float getAgeScale() {
        return this.getSeaSerpentScale();
    }

    public void refreshDimensions() {
        super.refreshDimensions();
        float scale = this.getSeaSerpentScale();
        if (scale != this.lastScale) {
            this.updateScale(this.getSeaSerpentScale());
        }
        this.lastScale = scale;
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            return true;
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        this.refreshDimensions();
        this.onUpdateParts();
        if (this.isInWater()) {
            this.spawnParticlesAroundEntity((Entity)this, (int)this.getSeaSerpentScale());
        }
        if (!this.level().isClientSide && this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.getTarget() != null && !this.getTarget().isAlive()) {
            this.setTarget(null);
        }
        System.arraycopy(this.tailYaw, 0, this.prevTailYaw, 0, this.tailYaw.length);
        System.arraycopy(this.tailPitch, 0, this.prevTailPitch, 0, this.tailPitch.length);
        this.tailYaw[0] = this.yBodyRot;
        this.tailPitch[0] = this.getXRot();
        System.arraycopy(this.prevTailYaw, 0, this.tailYaw, 1, this.tailYaw.length - 1);
        System.arraycopy(this.prevTailPitch, 0, this.tailPitch, 1, this.tailPitch.length - 1);
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        this.setAirSupply(this.getMaxAirSupply());
    }

    public float getPieceYaw(int index, float partialTicks) {
        if (index < this.segments.length && index >= 0) {
            return this.prevTailYaw[index] + (this.tailYaw[index] - this.prevTailYaw[index]) * partialTicks;
        }
        return 0.0f;
    }

    public float getPiecePitch(int index, float partialTicks) {
        if (index < this.segments.length && index >= 0) {
            return this.prevTailPitch[index] + (this.tailPitch[index] - this.prevTailPitch[index]) * partialTicks;
        }
        return 0.0f;
    }

    private void spawnParticlesAroundEntity(Entity entity, int count) {
        for (int i = 0; i < count; ++i) {
            int x = (int)Math.round(entity.getX() + (double)(this.random.nextFloat() * entity.getBbWidth() * 2.0f) - (double)entity.getBbWidth());
            int y = (int)Math.round(entity.getY() + 0.5 + (double)(this.random.nextFloat() * entity.getBbHeight()));
            int z = (int)Math.round(entity.getZ() + (double)(this.random.nextFloat() * entity.getBbWidth() * 2.0f) - (double)entity.getBbWidth());
            if (!this.level().getBlockState(new BlockPos(x, y, z)).is(Blocks.WATER)) continue;
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        }
    }

    private void spawnSlamParticles() {
        int i = 0;
        while ((float)i < this.getSeaSerpentScale() * 3.0f) {
            for (int i1 = 0; i1 < 5; ++i1) {
                double motionX = this.getRandom().nextGaussian() * 0.07;
                double motionY = this.getRandom().nextGaussian() * 0.07;
                double motionZ = this.getRandom().nextGaussian() * 0.07;
                float radius = 1.25f * this.getSeaSerpentScale();
                float angle = (float)Math.PI / 180 * this.yBodyRot + (float)i1 * 1.0f;
                double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * Mth.cos((float)angle);
                if (!this.level().isClientSide) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, true, this.getX() + extraX, this.getY() + extraY, this.getZ() + extraZ, motionX, motionY, motionZ);
            }
            ++i;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)IafSeaSerpentTypes.BLUE.getName());
        builder.define(SCALE, (Object)Float.valueOf(0.0f));
        builder.define(JUMPING, (Object)false);
        builder.define(BREATHING, (Object)false);
        builder.define(ANCIENT, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Variant", this.getVariant());
        compound.putInt("TicksSinceRoar", this.ticksSinceRoar);
        compound.putInt("JumpCooldown", this.jumpCooldown);
        compound.putFloat("Scale", this.getSeaSerpentScale());
        compound.putBoolean("JumpingOutOfWater", this.isJumpingOutOfWater());
        compound.putBoolean("AttackDecision", this.attackDecision);
        compound.putBoolean("Breathing", this.isBreathing());
        compound.putBoolean("Ancient", this.isAncient());
        this.removeParts();
        this.lastScale = 0.0f;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Variant") && compound.get("Variant").getId() == 8) {
            this.setVariant(compound.getString("Variant"));
        } else {
            this.setVariant(SeaSerpentType.values().get(compound.getInt("Variant")).getName());
        }
        this.ticksSinceRoar = compound.getInt("TicksSinceRoar");
        this.jumpCooldown = compound.getInt("JumpCooldown");
        this.setSeaSerpentScale(compound.getFloat("Scale"));
        this.setJumpingOutOfWater(compound.getBoolean("JumpingOutOfWater"));
        this.attackDecision = compound.getBoolean("AttackDecision");
        this.setBreathing(compound.getBoolean("Breathing"));
        this.setAncient(compound.getBoolean("Ancient"));
        this.setConfigurableAttributes();
    }

    private void updateAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(Math.min(0.25, 0.15 * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(Math.max(4.0, (Double)IafCommonConfig.INSTANCE.seaSerpent.attackDamage.getValue() * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(Math.max(10.0, (Double)IafCommonConfig.INSTANCE.seaSerpent.baseHealth.getValue() * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue((double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue()));
        this.heal(30.0f * this.getSeaSerpentScale());
    }

    private float getAncientModifier() {
        return this.isAncient() ? 1.5f : 1.0f;
    }

    public float getSeaSerpentScale() {
        float scale = ((Float)this.entityData.get(SCALE)).floatValue();
        if (scale == 0.0f) {
            scale = (float)RandomHelper.nextDouble((double)1.0, (double)5.0);
            this.setSeaSerpentScale(scale);
        }
        return scale;
    }

    private void setSeaSerpentScale(float scale) {
        this.entityData.set(SCALE, (Object)Float.valueOf(scale));
    }

    public String getVariant() {
        return (String)this.entityData.get(VARIANT);
    }

    public void setVariant(String variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public boolean isJumpingOutOfWater() {
        return (Boolean)this.entityData.get(JUMPING);
    }

    public void setJumpingOutOfWater(boolean jump) {
        this.entityData.set(JUMPING, (Object)jump);
    }

    public boolean isAncient() {
        return (Boolean)this.entityData.get(ANCIENT);
    }

    public void setAncient(boolean ancient) {
        this.entityData.set(ANCIENT, (Object)ancient);
    }

    public boolean isBreathing() {
        if (this.level().isClientSide) {
            boolean breathing;
            this.isBreathing = breathing = ((Boolean)this.entityData.get(BREATHING)).booleanValue();
            return breathing;
        }
        return this.isBreathing;
    }

    public void setBreathing(boolean breathing) {
        this.entityData.set(BREATHING, (Object)breathing);
        if (!this.level().isClientSide) {
            this.isBreathing = breathing;
        }
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void aiStep() {
        Entity entity;
        super.aiStep();
        if (!this.level().isClientSide && this.level().getDifficulty() == Difficulty.PEACEFUL && this.getTarget() instanceof Player) {
            this.setTarget(null);
        }
        boolean breathing = this.isBreathing() && this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_ROAR;
        boolean jumping = !this.isInWater() && !this.onGround() && this.getDeltaMovement().y >= 0.0;
        boolean wantJumping = false;
        boolean ground = !this.isInWater() && this.onGround();
        boolean prevJumping = this.isJumpingOutOfWater();
        ++this.ticksSinceRoar;
        ++this.jumpCooldown;
        this.prevJumpRot = this.jumpRot;
        if (this.ticksSinceRoar > 300 && this.isAtSurface() && this.getAnimation() != ANIMATION_BITE && this.jumpProgress == 0.0f && !this.isJumpingOutOfWater()) {
            this.setAnimation(ANIMATION_ROAR);
            this.ticksSinceRoar = 0;
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 1) {
            this.playSound((SoundEvent)IafSounds.SEA_SERPENT_ROAR.get(), this.getSoundVolume() + 1.0f, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 5) {
            this.playSound((SoundEvent)IafSounds.SEA_SERPENT_BITE.get(), this.getSoundVolume(), 1.0f);
        }
        if (this.isJumpingOutOfWater() && SeaSerpentEntity.isWaterBlock(this.level(), this.blockPosition().above(2))) {
            this.setJumpingOutOfWater(false);
        }
        this.swimCycle = this.swimCycle < 38 ? (this.swimCycle += 2) : 0;
        if (breathing && this.breathProgress < 20.0f) {
            this.breathProgress += 0.5f;
        } else if (!breathing && this.breathProgress > 0.0f) {
            this.breathProgress -= 0.5f;
        }
        if (jumping && this.jumpProgress < 10.0f) {
            this.jumpProgress += 0.5f;
        } else if (!jumping && this.jumpProgress > 0.0f) {
            this.jumpProgress -= 0.5f;
        }
        if (!wantJumping && this.wantJumpProgress > 0.0f) {
            this.wantJumpProgress -= 2.0f;
        }
        if (this.isJumpingOutOfWater() && this.jumpRot < 1.0f) {
            this.jumpRot += 0.1f;
        } else if (!this.isJumpingOutOfWater() && this.jumpRot > 0.0f) {
            this.jumpRot -= 0.1f;
        }
        if (prevJumping && !this.isJumpingOutOfWater()) {
            this.playSound((SoundEvent)IafSounds.SEA_SERPENT_SPLASH.get(), 5.0f, 0.75f);
            this.spawnSlamParticles();
            this.doSplashDamage();
        }
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        this.setXRot(Mth.clamp((float)((float)this.getDeltaMovement().y * 20.0f), (float)-90.0f, (float)90.0f));
        if (this.changedSwimBehavior) {
            this.changedSwimBehavior = false;
        }
        if (!this.level().isClientSide) {
            if (this.attackDecision) {
                this.setBreathing(false);
            }
            if (this.getTarget() != null && this.getAnimation() != ANIMATION_ROAR) {
                if (!this.attackDecision) {
                    if (!this.getTarget().isInWater() || !this.hasLineOfSight((Entity)this.getTarget()) || this.distanceTo((Entity)this.getTarget()) < 30.0f * this.getSeaSerpentScale()) {
                        this.attackDecision = true;
                    }
                    if (!this.attackDecision) {
                        this.shoot(this.getTarget());
                    }
                } else if (this.distanceToSqr((Entity)this.getTarget()) > (double)(200.0f * this.getSeaSerpentScale())) {
                    this.attackDecision = false;
                }
            } else {
                this.setBreathing(false);
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && this.getTarget() != null && (this.isTouchingMob((Entity)this.getTarget()) || this.distanceToSqr((Entity)this.getTarget()) < 50.0)) {
            this.hurtMob(this.getTarget());
        }
        this.breakBlock();
        if (!this.level().isClientSide && this.isPassenger() && (entity = this.getRootVehicle()) instanceof Boat) {
            Boat boat = (Boat)entity;
            boat.remove(Entity.RemovalReason.KILLED);
            this.stopRiding();
        }
    }

    private boolean isAtSurface() {
        BlockPos pos = this.blockPosition();
        return SeaSerpentEntity.isWaterBlock(this.level(), pos.below()) && !SeaSerpentEntity.isWaterBlock(this.level(), pos.above());
    }

    private void doSplashDamage() {
        double getWidth = 2.0 * (double)this.getSeaSerpentScale();
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(getWidth, getWidth * 0.5, getWidth), entity -> {
            if (!(entity instanceof LivingEntity)) return false;
            LivingEntity living = (LivingEntity)entity;
            if (entity instanceof SeaSerpentEntity) return false;
            if (!DragonUtils.isAlive(living)) return false;
            return true;
        });
        for (Entity entity2 : list) {
            if (!(entity2 instanceof LivingEntity) || !DragonUtils.isAlive((LivingEntity)entity2)) continue;
            entity2.hurt(this.level().damageSources().mobAttack((LivingEntity)this), (float)((int)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue()));
            this.destroyBoat(entity2);
            double xRatio = this.getX() - entity2.getX();
            double zRatio = this.getZ() - entity2.getZ();
            float f = Mth.sqrt((float)((float)(xRatio * xRatio + zRatio * zRatio)));
            float strength = 0.3f * this.getSeaSerpentScale();
            entity2.setDeltaMovement(entity2.getDeltaMovement().multiply(0.5, 1.0, 0.5));
            entity2.setDeltaMovement(entity2.getDeltaMovement().add(xRatio / (double)f * (double)strength, (double)strength, zRatio / (double)f * (double)strength));
        }
    }

    public void destroyBoat(Entity sailor) {
        Entity entity;
        if (sailor.getVehicle() != null && (entity = sailor.getVehicle()) instanceof Boat) {
            Boat boat = (Boat)entity;
            if (!this.level().isClientSide) {
                boat.remove(Entity.RemovalReason.KILLED);
                if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    for (int i = 0; i < 3; ++i) {
                        boat.spawnAtLocation(new ItemStack((ItemLike)boat.getVariant().getPlanks().asItem()), 0.0f);
                    }
                    for (int j = 0; j < 2; ++j) {
                        boat.spawnAtLocation(new ItemStack((ItemLike)Items.STICK));
                    }
                }
            }
        }
    }

    private boolean isPreyAtSurface() {
        if (this.getTarget() != null) {
            BlockPos pos = this.getTarget().blockPosition();
            return !SeaSerpentEntity.isWaterBlock(this.level(), pos.above((int)Math.ceil(this.getTarget().getBbHeight())));
        }
        return false;
    }

    private void hurtMob(LivingEntity entity) {
        if (this.getAnimation() == ANIMATION_BITE && entity != null && this.getAnimationTick() == 6) {
            this.getTarget().hurt(this.level().damageSources().mobAttack((LivingEntity)this), (float)((int)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue()));
            this.attackDecision = this.getRandom().nextBoolean();
        }
    }

    public void moveJumping() {
        float velocity = 0.5f;
        double x = -Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180)));
        double z = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180)));
        float f = Mth.sqrt((float)((float)(x * x + z * z)));
        x /= (double)f;
        z /= (double)f;
        this.setDeltaMovement(x *= (double)velocity, this.getDeltaMovement().y, z *= (double)velocity);
    }

    public boolean isTouchingMob(Entity entity) {
        if (this.getBoundingBox().expandTowards(1.0, 1.0, 1.0).intersects(entity.getBoundingBox())) {
            return true;
        }
        for (SlowPartEntity segment : this.segments) {
            if (segment == null || !segment.getBoundingBox().expandTowards(1.0, 1.0, 1.0).intersects(entity.getBoundingBox())) continue;
            return true;
        }
        return false;
    }

    public void breakBlock() {
        if (((Boolean)IafCommonConfig.INSTANCE.seaSerpent.griefing.getValue()).booleanValue()) {
            for (int a = (int)Math.round(this.getBoundingBox().minX) - 2; a <= (int)Math.round(this.getBoundingBox().maxX) + 2; ++a) {
                for (int b = (int)Math.round(this.getBoundingBox().minY) - 1; b <= (int)Math.round(this.getBoundingBox().maxY) + 2 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.getBoundingBox().minZ) - 2; c <= (int)Math.round(this.getBoundingBox().maxZ) + 2; ++c) {
                        BlockPos pos = new BlockPos(a, b, c);
                        BlockState state = this.level().getBlockState(pos);
                        FluidState fluidState = this.level().getFluidState(pos);
                        Block block = state.getBlock();
                        if (state.isAir() || state.getShape((BlockGetter)this.level(), pos).isEmpty() || !SeaSerpentEntity.canBreak(state.getBlock()) && !(state.getBlock() instanceof LeavesBlock) || !fluidState.isEmpty() || block == Blocks.AIR || this.level().isClientSide) continue;
                        this.level().destroyBlock(pos, true);
                    }
                }
            }
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        boolean ancient;
        spawnDataIn = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.setVariant(((SeaSerpentType)RandomHelper.randomOne(SeaSerpentType.values())).getName());
        boolean bl = ancient = this.getRandom().nextInt(16) == 1;
        if (ancient) {
            this.setAncient(true);
            this.setSeaSerpentScale(6.0f + this.getRandom().nextFloat() * 3.0f);
        } else {
            this.setSeaSerpentScale(1.5f + this.getRandom().nextFloat() * 4.0f);
        }
        this.updateAttributes();
        return spawnDataIn;
    }

    public void onWorldSpawn(RandomSource random) {
        boolean ancient;
        this.setVariant(((SeaSerpentType)RandomHelper.randomOne(SeaSerpentType.values())).getName());
        boolean bl = ancient = random.nextInt(15) == 1;
        if (ancient) {
            this.setAncient(true);
            this.setSeaSerpentScale(6.0f + random.nextFloat() * 3.0f);
        } else {
            this.setSeaSerpentScale(1.5f + random.nextFloat() * 4.0f);
        }
        this.updateAttributes();
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_ROAR, ANIMATION_SPEAK};
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)IafSounds.SEA_SERPENT_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)IafSounds.SEA_SERPENT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)IafSounds.SEA_SERPENT_DIE.get();
    }

    public void playAmbientSound() {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.playAmbientSound();
    }

    protected void playHurtSound(DamageSource source) {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.playHurtSound(source);
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    public boolean isBlinking() {
        return this.tickCount % 50 > 43;
    }

    private void shoot(LivingEntity entity) {
        if (!this.attackDecision) {
            if (!this.isInWater()) {
                this.setBreathing(false);
                this.attackDecision = true;
            }
            if (this.isBreathing()) {
                if (this.tickCount % 40 == 0) {
                    this.playSound((SoundEvent)IafSounds.SEA_SERPENT_BREATH.get(), 4.0f, 1.0f);
                }
                if (this.tickCount % 10 == 0) {
                    this.setYRot(this.yBodyRot);
                    float f1 = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    float headPosX = f1 + (float)(this.segments[0].getX() + (double)(1.3f * this.getSeaSerpentScale() * Mth.cos((float)((float)((double)(this.getYRot() + 90.0f) * Math.PI / 180.0)))));
                    float headPosZ = f2 + (float)(this.segments[0].getZ() + (double)(1.3f * this.getSeaSerpentScale() * Mth.sin((float)((float)((double)(this.getYRot() + 90.0f) * Math.PI / 180.0)))));
                    float headPosY = f3 + (float)(this.segments[0].getY() + (double)(0.2f * this.getSeaSerpentScale()));
                    double d2 = entity.getX() - (double)headPosX;
                    double d3 = entity.getY() - (double)headPosY;
                    double d4 = entity.getZ() - (double)headPosZ;
                    float inaccuracy = 1.0f;
                    SeaSerpentBubblesEntity entitylargefireball = new SeaSerpentBubblesEntity((EntityType<? extends Fireball>)((EntityType)IafEntities.SEA_SERPENT_BUBBLES.get()), this.level(), this, d2 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                    entitylargefireball.setPos(headPosX, headPosY, headPosZ);
                    if (!this.level().isClientSide) {
                        this.level().addFreshEntity((Entity)entitylargefireball);
                    }
                    if (!entity.isAlive()) {
                        this.setBreathing(false);
                        this.attackDecision = this.getRandom().nextBoolean();
                    }
                }
            } else {
                this.setBreathing(true);
            }
        }
        this.lookAt((Entity)entity, 360.0f, 360.0f);
    }

    public SeaSerpentType getEnum() {
        return (SeaSerpentType)IafRegistries.SEA_SERPENT_TYPE.get(IceAndFire.id(this.getVariant()));
    }

    public void travel(Vec3 vec) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), vec);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(vec);
        }
    }

    public boolean killedEntity(ServerLevel world, LivingEntity entity) {
        this.attackDecision = this.getRandom().nextBoolean();
        return this.attackDecision;
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public int getMaxFallDistance() {
        return 1000;
    }

    public boolean shouldUseJumpAttack(LivingEntity attackTarget) {
        return !attackTarget.isInWater() || this.isPreyAtSurface();
    }

    public boolean isInvulnerableTo(DamageSource source) {
        DamageSources damageSources = this.level().damageSources();
        return source == damageSources.fall() || source == damageSources.drown() || source == damageSources.inWall() || source.getEntity() != null && source == damageSources.fallingBlock(source.getEntity()) || source == damageSources.lava() || source.is(DamageTypes.IN_FIRE) || super.isInvulnerableTo(source);
    }

    public static class SwimmingMoveHelper
    extends MoveControl {
        private final SeaSerpentEntity dolphin;

        public SwimmingMoveHelper(SeaSerpentEntity dolphinIn) {
            super((Mob)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void tick() {
            if (this.dolphin.isInWater()) {
                this.dolphin.setDeltaMovement(this.dolphin.getDeltaMovement().add(0.0, 0.005, 0.0));
            }
            if (this.operation == MoveControl.Operation.MOVE_TO && !this.dolphin.getNavigation().isDone()) {
                double d2;
                double d1;
                double d0 = this.wantedX - this.dolphin.getX();
                double d3 = d0 * d0 + (d1 = this.wantedY - this.dolphin.getY()) * d1 + (d2 = this.wantedZ - this.dolphin.getZ()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.mob.setZza(0.0f);
                } else {
                    float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.setYRot(this.rotlerp(this.dolphin.getYRot(), f, 10.0f));
                    this.dolphin.yBodyRot = this.dolphin.getYRot();
                    this.dolphin.yHeadRot = this.dolphin.getYRot();
                    float f1 = (float)(this.speedModifier * 3.0);
                    if (this.dolphin.isInWater()) {
                        this.dolphin.setSpeed(f1 * 0.02f);
                        float f2 = -((float)(Mth.atan2((double)d1, (double)Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.setDeltaMovement(this.dolphin.getDeltaMovement().add(0.0, (double)this.dolphin.getSpeed() * d1 * 0.6, 0.0));
                        this.dolphin.setXRot(this.rotlerp(this.dolphin.getXRot(), f2, 1.0f));
                        float f3 = Mth.cos((float)(this.dolphin.getXRot() * ((float)Math.PI / 180)));
                        float f4 = Mth.sin((float)(this.dolphin.getXRot() * ((float)Math.PI / 180)));
                        this.dolphin.zza = f3 * f1;
                        this.dolphin.yya = -f4 * f1;
                    } else {
                        this.dolphin.setSpeed(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.setSpeed(0.0f);
                this.dolphin.setXxa(0.0f);
                this.dolphin.setYya(0.0f);
                this.dolphin.setZza(0.0f);
            }
        }
    }
}

