/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.entity.util.BlacklistedFromStatues;
import com.iafenvoy.iceandfire.registry.IafEntities;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class StoneStatueEntity
extends LivingEntity
implements BlacklistedFromStatues {
    private static final EntityDataAccessor<String> TRAPPED_ENTITY_TYPE = SynchedEntityData.defineId(StoneStatueEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<CompoundTag> TRAPPED_ENTITY_DATA = SynchedEntityData.defineId(StoneStatueEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<Float> TRAPPED_ENTITY_WIDTH = SynchedEntityData.defineId(StoneStatueEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> TRAPPED_ENTITY_HEIGHT = SynchedEntityData.defineId(StoneStatueEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> TRAPPED_ENTITY_SCALE = SynchedEntityData.defineId(StoneStatueEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> CRACK_AMOUNT = SynchedEntityData.defineId(StoneStatueEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private EntityDimensions stoneStatueSize = EntityDimensions.fixed((float)0.5f, (float)0.5f);

    public StoneStatueEntity(EntityType<? extends LivingEntity> t, Level worldIn) {
        super(t, worldIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    public static StoneStatueEntity buildStatueEntity(LivingEntity parent) {
        StoneStatueEntity statue = (StoneStatueEntity)((EntityType)IafEntities.STONE_STATUE.get()).create(parent.level());
        CompoundTag entityTag = new CompoundTag();
        try {
            if (!(parent instanceof Player)) {
                parent.saveWithoutId(entityTag);
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.debug("Encountered issue creating stone statue from {}", (Object)parent);
        }
        assert (statue != null);
        statue.setTrappedTag(entityTag);
        statue.setTrappedEntityTypeString(BuiltInRegistries.ENTITY_TYPE.getKey((Object)parent.getType()).toString());
        statue.setTrappedEntityWidth(parent.getBbWidth());
        statue.setTrappedHeight(parent.getBbHeight());
        statue.setTrappedScale(parent.getAgeScale());
        return statue;
    }

    public void push(Entity entityIn) {
    }

    public void baseTick() {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TRAPPED_ENTITY_TYPE, (Object)"minecraft:pig");
        builder.define(TRAPPED_ENTITY_DATA, (Object)new CompoundTag());
        builder.define(TRAPPED_ENTITY_WIDTH, (Object)Float.valueOf(0.5f));
        builder.define(TRAPPED_ENTITY_HEIGHT, (Object)Float.valueOf(0.5f));
        builder.define(TRAPPED_ENTITY_SCALE, (Object)Float.valueOf(1.0f));
        builder.define(CRACK_AMOUNT, (Object)0);
    }

    public EntityType<?> getTrappedEntityType() {
        return EntityType.byString((String)this.getTrappedEntityTypeString()).orElse(EntityType.PIG);
    }

    public String getTrappedEntityTypeString() {
        return (String)this.entityData.get(TRAPPED_ENTITY_TYPE);
    }

    public void setTrappedEntityTypeString(String string) {
        this.entityData.set(TRAPPED_ENTITY_TYPE, (Object)string);
    }

    public CompoundTag getTrappedTag() {
        return (CompoundTag)this.entityData.get(TRAPPED_ENTITY_DATA);
    }

    public void setTrappedTag(CompoundTag tag) {
        this.entityData.set(TRAPPED_ENTITY_DATA, (Object)tag);
    }

    public float getTrappedWidth() {
        return ((Float)this.entityData.get(TRAPPED_ENTITY_WIDTH)).floatValue();
    }

    public void setTrappedEntityWidth(float size) {
        this.entityData.set(TRAPPED_ENTITY_WIDTH, (Object)Float.valueOf(size));
    }

    public float getTrappedHeight() {
        return ((Float)this.entityData.get(TRAPPED_ENTITY_HEIGHT)).floatValue();
    }

    public void setTrappedHeight(float size) {
        this.entityData.set(TRAPPED_ENTITY_HEIGHT, (Object)Float.valueOf(size));
    }

    public float getTrappedScale() {
        return ((Float)this.entityData.get(TRAPPED_ENTITY_SCALE)).floatValue();
    }

    public void setTrappedScale(float size) {
        this.entityData.set(TRAPPED_ENTITY_SCALE, (Object)Float.valueOf(size));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("CrackAmount", this.getCrackAmount());
        tag.putFloat("StatueWidth", this.getTrappedWidth());
        tag.putFloat("StatueHeight", this.getTrappedHeight());
        tag.putFloat("StatueScale", this.getTrappedScale());
        tag.putString("StatueEntityType", this.getTrappedEntityTypeString());
        tag.put("StatueEntityTag", (Tag)this.getTrappedTag());
    }

    public float getAgeScale() {
        return this.getTrappedScale();
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setCrackAmount(tag.getByte("CrackAmount"));
        this.setTrappedEntityWidth(tag.getFloat("StatueWidth"));
        this.setTrappedHeight(tag.getFloat("StatueHeight"));
        this.setTrappedScale(tag.getFloat("StatueScale"));
        this.setTrappedEntityTypeString(tag.getString("StatueEntityType"));
        if (tag.contains("StatueEntityTag")) {
            this.setTrappedTag(tag.getCompound("StatueEntityTag"));
        }
    }

    public boolean isInvulnerable() {
        return true;
    }

    public EntityDimensions getDimensions(Pose poseIn) {
        return this.stoneStatueSize;
    }

    public void tick() {
        super.tick();
        this.setYRot(this.yBodyRot);
        this.yHeadRot = this.getYRot();
        if ((double)Math.abs(this.getBbWidth() - this.getTrappedWidth()) > 0.01 || (double)Math.abs(this.getBbHeight() - this.getTrappedHeight()) > 0.01) {
            double prevX = this.getX();
            double prevZ = this.getZ();
            this.stoneStatueSize = EntityDimensions.scalable((float)this.getTrappedWidth(), (float)this.getTrappedHeight());
            this.refreshDimensions();
            this.setPos(prevX, this.getY(), prevZ);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypeTags.IS_PROJECTILE) && amount > 0.0f) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                level = this.getTrappedEntityType().create((Level)serverWorld);
                if (level instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)level;
                    ExperienceOrb.award((ServerLevel)serverWorld, (Vec3)this.position(), (int)livingEntity.getBaseExperienceReward());
                }
            }
            this.remove(Entity.RemovalReason.KILLED);
            return true;
        }
        return super.hurt(source, amount);
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
    }

    public Iterable<ItemStack> getArmorSlots() {
        return ImmutableList.of();
    }

    public ItemStack getItemBySlot(EquipmentSlot slotIn) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public int getCrackAmount() {
        return (Integer)this.entityData.get(CRACK_AMOUNT);
    }

    public void setCrackAmount(int crackAmount) {
        this.entityData.set(CRACK_AMOUNT, (Object)crackAmount);
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }
}

