/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.CyclopsEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class EntitySheepAIFollowCyclopsGoal
extends Goal {
    final Animal childAnimal;
    final double moveSpeed;
    CyclopsEntity cyclops;
    private int delayCounter;

    public EntitySheepAIFollowCyclopsGoal(Animal animal, double speed) {
        this.childAnimal = animal;
        this.moveSpeed = speed;
    }

    public boolean canUse() {
        List list = this.childAnimal.level().getEntitiesOfClass(CyclopsEntity.class, this.childAnimal.getBoundingBox().inflate(16.0, 8.0, 16.0));
        CyclopsEntity cyclops = null;
        double d0 = Double.MAX_VALUE;
        for (CyclopsEntity cyclops1 : list) {
            double d1 = this.childAnimal.distanceToSqr((Entity)cyclops1);
            if (!(d1 <= d0)) continue;
            d0 = d1;
            cyclops = cyclops1;
        }
        if (cyclops == null) {
            return false;
        }
        if (d0 < 10.0) {
            return false;
        }
        this.cyclops = cyclops;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.cyclops.isAlive()) {
            return false;
        }
        double d0 = this.childAnimal.distanceToSqr((Entity)this.cyclops);
        return d0 >= 9.0 && d0 <= 256.0;
    }

    public void start() {
        this.delayCounter = 0;
    }

    public void stop() {
        this.cyclops = null;
    }

    public void tick() {
        if (--this.delayCounter <= 0) {
            Path path;
            this.delayCounter = this.adjustedTickDelay(10);
            if (this.childAnimal.distanceToSqr((Entity)this.cyclops) > 10.0 && (path = this.getPathToLivingEntity(this.childAnimal, this.cyclops)) != null) {
                this.childAnimal.getNavigation().moveTo(path, this.moveSpeed);
            }
        }
    }

    public Path getPathToLivingEntity(Animal entityIn, CyclopsEntity cyclops) {
        PathNavigation navi = entityIn.getNavigation();
        Vec3 Vector3d = DefaultRandomPos.getPosTowards((PathfinderMob)entityIn, (int)2, (int)7, (Vec3)cyclops.position(), (double)1.5707963705062866);
        if (Vector3d != null) {
            BlockPos blockpos = BlockPos.containing((Position)Vector3d);
            return navi.createPath(blockpos, 0);
        }
        return null;
    }
}

