/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.event;

import com.iafenvoy.iceandfire.data.component.ChainData;
import com.iafenvoy.iceandfire.data.component.MiscData;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.util.ICustomMoveController;
import com.iafenvoy.iceandfire.network.payload.DragonControlC2SPayload;
import com.iafenvoy.iceandfire.registry.IafKeybindings;
import com.iafenvoy.iceandfire.registry.IafStatusEffects;
import com.iafenvoy.iceandfire.render.misc.ChainRenderer;
import com.iafenvoy.iceandfire.render.misc.CockatriceBeamRenderer;
import com.iafenvoy.iceandfire.render.misc.FrozenStateRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ClientEvents {
    public static int currentView = 0;
    public static final CopyOnWriteArrayList<Tuple<Vec3, Vec3>> LIGHTNINGS = new CopyOnWriteArrayList();

    public static void onCameraSetup(Camera camera) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.getVehicle() instanceof DragonBaseEntity) {
            float scale = ((DragonBaseEntity)player.getVehicle()).getRenderSize() / 3.0f;
            if (Minecraft.getInstance().options.getCameraType() == CameraType.THIRD_PERSON_BACK || Minecraft.getInstance().options.getCameraType() == CameraType.THIRD_PERSON_FRONT) {
                if (currentView == 1) {
                    camera.move(-camera.getMaxZoom(scale * 1.2f), 0.0f, 0.0f);
                } else if (currentView == 2) {
                    camera.move(-camera.getMaxZoom(scale * 3.0f), 0.0f, 0.0f);
                } else if (currentView == 3) {
                    camera.move(-camera.getMaxZoom(scale * 5.0f), 0.0f, 0.0f);
                }
            }
        }
    }

    public static void onLivingUpdate(LivingEntity entity) {
        Entity controlState2;
        Player player;
        Minecraft mc = Minecraft.getInstance();
        if (entity instanceof ICustomMoveController) {
            ICustomMoveController moveController = (ICustomMoveController)entity;
            if (entity.getVehicle() != null && entity.getVehicle() == mc.player) {
                byte previousState = moveController.getControlState();
                moveController.dismount(mc.options.keyShift.isDown());
                byte controlState2 = moveController.getControlState();
                if (controlState2 != previousState) {
                    NetworkManager.sendToServer((CustomPacketPayload)new DragonControlC2SPayload(entity.getId(), controlState2, entity.blockPosition()));
                }
            }
        }
        if (entity instanceof Player && (player = (Player)entity) == Minecraft.getInstance().player && (controlState2 = player.getVehicle()) instanceof ICustomMoveController) {
            ICustomMoveController controller = (ICustomMoveController)controlState2;
            Entity vehicle = player.getVehicle();
            byte previousState = controller.getControlState();
            controller.up(mc.options.keyJump.isDown());
            controller.down(IafKeybindings.DRAGON_DOWN.isDown());
            controller.attack(IafKeybindings.DRAGON_STRIKE.isDown());
            controller.dismount(mc.options.keyShift.isDown());
            controller.strike(IafKeybindings.DRAGON_BREATH.isDown());
            byte controlState3 = controller.getControlState();
            if (controlState3 != previousState) {
                NetworkManager.sendToServer((CustomPacketPayload)new DragonControlC2SPayload(vehicle.getId(), controlState3, vehicle.blockPosition()));
            }
        }
    }

    public static void onPostRenderLiving(LivingEntity entity, float partialRenderTick, PoseStack matrixStack, MultiBufferSource buffers, int light) {
        MiscData miscData = MiscData.get(entity);
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        miscData.checkScepterTarget(arg_0 -> ((LevelEntityGetter)world.entityStorage.getEntityGetter()).get(arg_0));
        for (UUID target : miscData.getTargetedByScepters()) {
            CockatriceBeamRenderer.render((Entity)entity, (Entity)world.entityStorage.getEntityGetter().get(target), matrixStack, buffers, partialRenderTick);
        }
        MobEffectInstance effect = entity.getEffect(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)IafStatusEffects.FROZEN.get())));
        if (effect != null) {
            FrozenStateRenderer.render(entity, matrixStack, buffers, light, effect.getDuration());
        }
        ChainData chainData = ChainData.get(entity);
        ChainRenderer.render(entity, matrixStack, buffers, light, chainData.getChainedTo());
    }
}

