/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.registry.IafDataComponents;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.world.DragonPosWorldData;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class SummoningCrystalItem
extends Item {
    public SummoningCrystalItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public static boolean hasDragon(ItemStack stack) {
        CompoundTag nbt = (CompoundTag)stack.get((DataComponentType)IafDataComponents.CRYSTAL_DRAGON_DATA.get());
        if (stack.getItem() instanceof SummoningCrystalItem && nbt != null) {
            for (String tagInfo : nbt.getAllKeys()) {
                if (!tagInfo.contains("Dragon")) continue;
                return true;
            }
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        CompoundTag nbt;
        super.appendHoverText(stack, context, tooltip, type);
        boolean flag = false;
        String desc = "entity.iceandfire.fire_dragon";
        if (stack.getItem() == IafItems.SUMMONING_CRYSTAL_ICE.get()) {
            desc = "entity.iceandfire.ice_dragon";
        }
        if (stack.getItem() == IafItems.SUMMONING_CRYSTAL_LIGHTNING.get()) {
            desc = "entity.iceandfire.lightning_dragon";
        }
        if ((nbt = (CompoundTag)stack.get((DataComponentType)IafDataComponents.CRYSTAL_DRAGON_DATA.get())) != null) {
            for (String tagInfo : nbt.getAllKeys()) {
                if (!tagInfo.contains("Dragon")) continue;
                CompoundTag dragonTag = nbt.getCompound(tagInfo);
                String dragonName = I18n.get((String)desc, (Object[])new Object[0]);
                if (!dragonTag.getString("CustomName").isEmpty()) {
                    dragonName = dragonTag.getString("CustomName");
                }
                tooltip.add((Component)Component.translatable((String)"item.iceandfire.summoning_crystal.bound", (Object[])new Object[]{dragonName}).withStyle(ChatFormatting.GRAY));
                flag = true;
            }
        }
        if (!flag) {
            tooltip.add((Component)Component.translatable((String)"item.iceandfire.summoning_crystal.desc_0").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"item.iceandfire.summoning_crystal.desc_1").withStyle(ChatFormatting.GRAY));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        assert (context.getPlayer() != null);
        ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
        boolean flag = false;
        BlockPos offsetPos = context.getClickedPos().relative(context.getClickedFace());
        float yaw = context.getPlayer().getYRot();
        boolean displayError = false;
        CompoundTag nbt = (CompoundTag)stack.get((DataComponentType)IafDataComponents.CRYSTAL_DRAGON_DATA.get());
        if (nbt != null && stack.getItem() == this && SummoningCrystalItem.hasDragon(stack)) {
            for (String tagInfo : nbt.getAllKeys()) {
                CompoundTag dragonTag;
                UUID id;
                if (!tagInfo.contains("Dragon") || (id = (dragonTag = nbt.getCompound(tagInfo)).getUUID("DragonUUID")) == null || context.getLevel().isClientSide) continue;
                try {
                    Entity entity = context.getLevel().getServer().getLevel(context.getPlayer().level().dimension()).getEntity(id);
                    if (entity != null) {
                        flag = true;
                        this.summonEntity(entity, context.getLevel(), offsetPos, yaw);
                    }
                }
                catch (Exception e) {
                    IceAndFire.LOGGER.error((Object)e);
                    displayError = true;
                }
                DragonPosWorldData data = DragonPosWorldData.get(context.getLevel());
                BlockPos dragonChunkPos = null;
                if (data != null) {
                    dragonChunkPos = data.getDragonPos(id);
                }
                if (!((Boolean)IafCommonConfig.INSTANCE.dragon.chunkLoadSummonCrystal.getValue()).booleanValue()) continue;
                try {
                    if (flag || data == null || !context.getLevel().isClientSide) continue;
                    ServerLevel serverWorld = (ServerLevel)context.getLevel();
                    ChunkPos pos = new ChunkPos(dragonChunkPos);
                    serverWorld.setChunkForced(pos.x, pos.z, true);
                }
                catch (Exception e) {
                    IceAndFire.LOGGER.warn("Could not load chunk when summoning dragon", (Throwable)e);
                }
            }
            if (flag) {
                context.getPlayer().playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                context.getPlayer().playSound(SoundEvents.GLASS_BREAK, 1.0f, 1.0f);
                context.getPlayer().swing(context.getHand());
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"message.iceandfire.dragonTeleport"), true);
                stack.remove((DataComponentType)IafDataComponents.CRYSTAL_DRAGON_DATA.get());
            } else if (displayError) {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"message.iceandfire.noDragonTeleport"), true);
            }
        }
        return InteractionResult.PASS;
    }

    public void summonEntity(Entity entity, Level worldIn, BlockPos offsetPos, float yaw) {
        DragonPosWorldData data;
        entity.moveTo((double)offsetPos.getX() + 0.5, (double)offsetPos.getY() + 0.5, (double)offsetPos.getZ() + 0.5, yaw, 0.0f);
        if (entity instanceof DragonBaseEntity) {
            DragonBaseEntity dragon = (DragonBaseEntity)entity;
            dragon.setCrystalBound(false);
        }
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.chunkLoadSummonCrystal.getValue()).booleanValue() && (data = DragonPosWorldData.get(worldIn)) != null) {
            data.removeDragon(entity.getUUID());
        }
    }
}

