/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.tool;

import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.IafToolMaterials;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

public class AmphithereMacuahuitlItem
extends SwordItem {
    public AmphithereMacuahuitlItem() {
        super((Tier)IafToolMaterials.AMPHITHERE_SWORD_TOOL_MATERIAL, new Item.Properties().component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)AmphithereMacuahuitlItem.createAttributes((Tier)IafToolMaterials.AMPHITHERE_SWORD_TOOL_MATERIAL, (int)3, (float)-2.4f)));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity targetEntity, LivingEntity attacker) {
        targetEntity.playSound((SoundEvent)IafSounds.AMPHITHERE_GUST.get(), 1.0f, 1.0f);
        targetEntity.playSound(SoundEvents.SHIELD_BLOCK, 1.0f, 1.0f);
        targetEntity.hasImpulse = true;
        double xRatio = -Mth.sin((float)(attacker.getYRot() * ((float)Math.PI / 180)));
        double zRatio = Mth.cos((float)(attacker.getYRot() * ((float)Math.PI / 180)));
        float strength = -0.6f;
        float f = Mth.sqrt((float)((float)(xRatio * xRatio + zRatio * zRatio)));
        targetEntity.setDeltaMovement(targetEntity.getDeltaMovement().x / 2.0 - xRatio / (double)f * (double)strength, 0.8, targetEntity.getDeltaMovement().z / 2.0 - zRatio / (double)f * (double)strength);
        Random rand = new Random();
        for (int i = 0; i < 20; ++i) {
            double d0 = rand.nextGaussian() * 0.02;
            double d1 = rand.nextGaussian() * 0.02;
            double d2 = rand.nextGaussian() * 0.02;
            targetEntity.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, targetEntity.getX() + (double)(rand.nextFloat() * targetEntity.getBbWidth() * 5.0f) - (double)targetEntity.getBbWidth() - d0 * 10.0, targetEntity.getY() + (double)(rand.nextFloat() * targetEntity.getBbHeight()) - d1 * 10.0, targetEntity.getZ() + (double)(rand.nextFloat() * targetEntity.getBbWidth() * 5.0f) - (double)targetEntity.getBbWidth() - d2 * 10.0, d0, d1, d2);
        }
        return super.hurtEnemy(stack, targetEntity, attacker);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.legendary_weapon.desc").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.amphithere_macuahuitl.desc_0").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.amphithere_macuahuitl.desc_1").withStyle(ChatFormatting.GRAY));
    }
}

