/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.mixin;

import com.iafenvoy.iceandfire.effect.FrozenStatusEffect;
import com.iafenvoy.iceandfire.event.CommonEvents;
import com.iafenvoy.iceandfire.item.ability.BuiltinAbilities;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import java.util.function.Consumer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    public abstract ItemStack getItemInHand(InteractionHand var1);

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void onEntityTick(CallbackInfo ci) {
        ((Consumer)CommonEvents.LIVING_TICK.invoker()).accept((LivingEntity)this);
    }

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at={@At(value="HEAD")})
    private void onSwingHand(InteractionHand hand, boolean fromServerPlayer, CallbackInfo ci) {
        if (this.getItemInHand(hand).is(IafItemTags.SUMMON_GHOST_SWORD) && BuiltinAbilities.SUMMON_GHOST_SWORD.isEnable()) {
            BuiltinAbilities.SUMMON_GHOST_SWORD.active((LivingEntity)this);
        }
    }

    @Inject(method={"onEffectRemoved(Lnet/minecraft/world/effect/MobEffectInstance;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;refreshDirtyAttributes()V")})
    private void handleFrozenEffectRemove(MobEffectInstance effect, CallbackInfo ci) {
        Object object = effect.getEffect().value();
        if (object instanceof FrozenStatusEffect) {
            FrozenStatusEffect e = (FrozenStatusEffect)((Object)object);
            e.onRemoved((LivingEntity)this);
        }
    }
}

