/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.network;

import com.iafenvoy.iceandfire.entity.AmphithereEntity;
import com.iafenvoy.iceandfire.entity.DeathWormEntity;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.HippocampusEntity;
import com.iafenvoy.iceandfire.entity.HippogryphEntity;
import com.iafenvoy.iceandfire.entity.HydraEntity;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.event.ServerEvents;
import com.iafenvoy.iceandfire.network.payload.DragonControlC2SPayload;
import com.iafenvoy.iceandfire.network.payload.DragonSetBurnBlockS2CPayload;
import com.iafenvoy.iceandfire.network.payload.LightningBoltS2CPayload;
import com.iafenvoy.iceandfire.network.payload.MultipartInteractC2SPayload;
import com.iafenvoy.iceandfire.network.payload.PlayerHitMultipartC2SPayload;
import com.iafenvoy.iceandfire.network.payload.StartRidingMobC2SPayload;
import com.iafenvoy.iceandfire.network.payload.StartRidingMobS2CPayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieHouseS2CPayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieJarS2CPayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePodiumS2CPayload;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ServerNetworkHelper {
    public static void registerReceivers() {
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType(DragonSetBurnBlockS2CPayload.ID, DragonSetBurnBlockS2CPayload.CODEC);
            NetworkManager.registerS2CPayloadType(LightningBoltS2CPayload.ID, LightningBoltS2CPayload.CODEC);
            NetworkManager.registerS2CPayloadType(StartRidingMobS2CPayload.ID, StartRidingMobS2CPayload.CODEC);
            NetworkManager.registerS2CPayloadType(UpdatePixieHouseS2CPayload.ID, UpdatePixieHouseS2CPayload.CODEC);
            NetworkManager.registerS2CPayloadType(UpdatePixieJarS2CPayload.ID, UpdatePixieJarS2CPayload.CODEC);
            NetworkManager.registerS2CPayloadType(UpdatePodiumS2CPayload.ID, UpdatePodiumS2CPayload.CODEC);
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, DragonControlC2SPayload.ID, DragonControlC2SPayload.CODEC, (payload, ctx) -> {
            Entity entity;
            Player player = ctx.getPlayer();
            if (player != null && ServerEvents.isRidingOrBeingRiddenBy(entity = player.level().getEntity(payload.dragonId()), (Entity)player)) {
                BlockPos pos = payload.pos();
                Entity entity2 = entity;
                Objects.requireNonNull(entity2);
                Entity selector0$temp = entity2;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DragonBaseEntity.class, HippogryphEntity.class, HippocampusEntity.class, DeathWormEntity.class, AmphithereEntity.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        DragonBaseEntity dragon = (DragonBaseEntity)selector0$temp;
                        if (!dragon.isOwnedBy((LivingEntity)player)) break;
                        dragon.setControlState(payload.controlState());
                        break;
                    }
                    case 1: {
                        HippogryphEntity hippogryph = (HippogryphEntity)selector0$temp;
                        if (!hippogryph.isOwnedBy((LivingEntity)player)) break;
                        hippogryph.setControlState(payload.controlState());
                        break;
                    }
                    case 2: {
                        HippocampusEntity hippo = (HippocampusEntity)selector0$temp;
                        if (hippo.isOwnedBy((LivingEntity)player)) {
                            hippo.setControlState(payload.controlState());
                        }
                        hippo.setPosRaw(pos.getX(), pos.getY(), pos.getZ());
                        break;
                    }
                    case 3: {
                        DeathWormEntity deathWorm = (DeathWormEntity)selector0$temp;
                        deathWorm.setControlState(payload.controlState());
                        deathWorm.setPosRaw(pos.getX(), pos.getY(), pos.getZ());
                        break;
                    }
                    case 4: {
                        AmphithereEntity amphithere = (AmphithereEntity)selector0$temp;
                        if (amphithere.isOwnedBy((LivingEntity)player)) {
                            amphithere.setControlState(payload.controlState());
                        }
                        amphithere.setPosRaw(pos.getX(), pos.getY(), pos.getZ());
                        break;
                    }
                }
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, MultipartInteractC2SPayload.ID, MultipartInteractC2SPayload.CODEC, (payload, ctx) -> {
            Player player = ctx.getPlayer();
            ctx.queue(() -> {
                LivingEntity livingEntity;
                double dist;
                ServerLevel serverWorld;
                Entity entity;
                Level patt0$temp;
                if (player != null && (patt0$temp = player.level()) instanceof ServerLevel && (entity = (serverWorld = (ServerLevel)patt0$temp).getEntity(payload.creatureID())) instanceof LivingEntity && (dist = (double)player.distanceTo((Entity)(livingEntity = (LivingEntity)entity))) < 100.0) {
                    float dmg = payload.dmg();
                    if (dmg > 0.0f) {
                        livingEntity.hurt(player.level().damageSources.mobAttack((LivingEntity)player), dmg);
                    } else {
                        livingEntity.interact(player, InteractionHand.MAIN_HAND);
                    }
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, PlayerHitMultipartC2SPayload.ID, PlayerHitMultipartC2SPayload.CODEC, (payload, ctx) -> {
            LivingEntity livingEntity;
            double dist;
            Entity entity;
            Player player = ctx.getPlayer();
            if (player != null && (entity = player.level().getEntity(payload.entityId())) instanceof LivingEntity && (dist = (double)player.distanceTo((Entity)(livingEntity = (LivingEntity)entity))) < 100.0) {
                player.attack((Entity)livingEntity);
                if (livingEntity instanceof HydraEntity) {
                    HydraEntity hydra = (HydraEntity)livingEntity;
                    hydra.triggerHeadFlags(payload.index());
                }
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, StartRidingMobC2SPayload.ID, StartRidingMobC2SPayload.CODEC, (payload, ctx) -> {
            TamableAnimal tamable;
            Entity entity;
            Player player = ctx.getPlayer();
            if (player != null && (entity = player.level().getEntity(payload.dragonId())) instanceof ISyncMount && entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).isOwnedBy((LivingEntity)player) && tamable.distanceTo((Entity)player) < 14.0f) {
                if (payload.ride()) {
                    if (payload.baby()) {
                        tamable.startRiding((Entity)player, true);
                    } else {
                        player.startRiding((Entity)tamable, true);
                    }
                } else if (payload.baby()) {
                    tamable.stopRiding();
                } else {
                    player.stopRiding();
                }
            }
        });
    }
}

