/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.entity.GhostEntity;
import com.iafenvoy.iceandfire.registry.IafRenderLayers;
import com.iafenvoy.iceandfire.render.model.GhostModel;
import com.iafenvoy.iceandfire.util.Color4i;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import org.joml.Matrix4f;

public class GhostEntityRenderer
extends MobRenderer<GhostEntity, GhostModel> {
    public static final ResourceLocation TEXTURE_0 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/ghost/ghost_white.png");
    public static final ResourceLocation TEXTURE_1 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/ghost/ghost_blue.png");
    public static final ResourceLocation TEXTURE_2 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/ghost/ghost_green.png");
    public static final ResourceLocation TEXTURE_SHOPPING_LIST = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/ghost/haunted_shopping_list.png");

    public GhostEntityRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (EntityModel)new GhostModel(0.0f), 0.55f);
    }

    public static ResourceLocation getGhostOverlayForType(int ghost) {
        return switch (ghost) {
            case 1 -> TEXTURE_1;
            case 2 -> TEXTURE_2;
            case -1 -> TEXTURE_SHOPPING_LIST;
            default -> TEXTURE_0;
        };
    }

    public void render(GhostEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        RenderType rendertype;
        Direction direction;
        Entity entity;
        boolean shouldSit;
        this.shadowRadius = 0.0f;
        matrixStackIn.pushPose();
        ((GhostModel)this.model).attackTime = this.getAttackAnim((LivingEntity)entityIn, partialTicks);
        ((GhostModel)this.model).riding = shouldSit = entityIn.isPassenger() && entityIn.getVehicle() != null;
        ((GhostModel)this.model).young = entityIn.isBaby();
        float f = Mth.rotLerp((float)partialTicks, (float)entityIn.yBodyRotO, (float)entityIn.yBodyRot);
        float f1 = Mth.rotLerp((float)partialTicks, (float)entityIn.yHeadRotO, (float)entityIn.yHeadRot);
        float f2 = f1 - f;
        if (shouldSit && (entity = entityIn.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f = Mth.rotLerp((float)partialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot());
        if (entityIn.getPose() == Pose.SLEEPING && (direction = entityIn.getBedOrientation()) != null) {
            float f4 = entityIn.getEyeHeight(Pose.STANDING) - 0.1f;
            matrixStackIn.translate((double)((float)(-direction.getStepX()) * f4), 0.0, (double)((float)(-direction.getStepZ()) * f4));
        }
        float f7 = this.getBob((LivingEntity)entityIn, partialTicks);
        this.setupRotations((LivingEntity)entityIn, matrixStackIn, f7, f, partialTicks, 1.0f);
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        this.scale(entityIn, matrixStackIn, partialTicks);
        matrixStackIn.translate(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.isAlive()) {
            f8 = entityIn.walkAnimation.speed();
            f5 = entityIn.walkAnimation.position();
            if (entityIn.isBaby()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((GhostModel)this.model).prepareMobModel((Entity)entityIn, f5, f8, partialTicks);
        ((GhostModel)this.model).setAngles(entityIn, f5, f8, f7, f2, f6);
        float alphaForRender = this.getAlphaForRender(entityIn, partialTicks);
        RenderType renderType = rendertype = entityIn.isDaytimeMode() ? IafRenderLayers.getGhostDaytime(this.getTexture(entityIn)) : IafRenderLayers.getGhost(this.getTexture(entityIn));
        if (!entityIn.isInvisible()) {
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(rendertype);
            int i = GhostEntityRenderer.getOverlayCoords((LivingEntity)entityIn, (float)this.getWhiteOverlayProgress((LivingEntity)entityIn, partialTicks));
            if (entityIn.isHauntedShoppingList()) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.0f, 0.8f + Mth.sin((float)(((float)entityIn.tickCount + partialTicks) * 0.15f)) * 0.1f, 0.0f);
                matrixStackIn.scale(0.6f, 0.6f, 0.6f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                matrixStackIn.pushPose();
                PoseStack.Pose entry = matrixStackIn.last();
                Matrix4f matrix4f = entry.pose();
                this.drawVertex(matrix4f, entry, ivertexbuilder, i, (int)(alphaForRender * 255.0f), -1, -2, 0, 1.0f, 0.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, entry, ivertexbuilder, i, (int)(alphaForRender * 255.0f), 1, -2, 0, 0.5f, 0.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, entry, ivertexbuilder, i, (int)(alphaForRender * 255.0f), 1, 2, 0, 0.5f, 1.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, entry, ivertexbuilder, i, (int)(alphaForRender * 255.0f), -1, 2, 0, 1.0f, 1.0f, 0, 1, 0, 240);
                matrixStackIn.popPose();
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                matrixStackIn.pushPose();
                entry = matrixStackIn.last();
                matrix4f = entry.pose();
                this.drawVertex(matrix4f, entry, ivertexbuilder, i, (int)(alphaForRender * 255.0f), -1, -2, 0, 0.0f, 0.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, entry, ivertexbuilder, i, (int)(alphaForRender * 255.0f), 1, -2, 0, 0.5f, 0.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, entry, ivertexbuilder, i, (int)(alphaForRender * 255.0f), 1, 2, 0, 0.5f, 1.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, entry, ivertexbuilder, i, (int)(alphaForRender * 255.0f), -1, 2, 0, 0.0f, 1.0f, 0, 1, 0, 240);
                matrixStackIn.popPose();
                matrixStackIn.popPose();
            } else {
                ((GhostModel)this.model).renderToBuffer(matrixStackIn, ivertexbuilder, 240, i, new Color4i(1.0, 1.0, 1.0, alphaForRender).getIntValue());
            }
        }
        if (!entityIn.isSpectator()) {
            for (RenderLayer layerrenderer : this.layers) {
                layerrenderer.render(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, f5, f8, partialTicks, f7, f2, f6);
            }
        }
        matrixStackIn.popPose();
    }

    protected float getLyingAngle(GhostEntity ghost) {
        return 0.0f;
    }

    public float getAlphaForRender(GhostEntity entityIn, float partialTicks) {
        if (entityIn.isDaytimeMode()) {
            return Mth.clamp((float)((float)(101 - Math.min(entityIn.getDaytimeCounter(), 100)) / 100.0f), (float)0.0f, (float)1.0f);
        }
        return Mth.clamp((float)((Mth.sin((float)(((float)entityIn.tickCount + partialTicks) * 0.1f)) + 1.0f) * 0.5f + 0.1f), (float)0.0f, (float)1.0f);
    }

    public void scale(GhostEntity LivingEntityIn, PoseStack stack, float partialTickTime) {
    }

    public ResourceLocation getTexture(GhostEntity ghost) {
        return switch (ghost.getColor()) {
            case 1 -> TEXTURE_1;
            case 2 -> TEXTURE_2;
            case -1 -> TEXTURE_SHOPPING_LIST;
            default -> TEXTURE_0;
        };
    }

    public void drawVertex(Matrix4f stack, PoseStack.Pose entry, VertexConsumer builder, int packedRed, int alphaInt, int x, int y, int z, float u, float v, int lightmap, int lightmap3, int lightmap2, int lightmap4) {
        builder.addVertex(stack, (float)x, (float)y, (float)z).setColor(255, 255, 255, alphaInt).setUv(u, v).setOverlay(packedRed).setLight(lightmap4).setNormal(entry, (float)lightmap, (float)lightmap2, (float)lightmap3);
    }
}

