/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity.feature;

import com.iafenvoy.iceandfire.entity.HydraEntity;
import com.iafenvoy.iceandfire.render.entity.HydraEntityRenderer;
import com.iafenvoy.iceandfire.render.model.HydraBodyModel;
import com.iafenvoy.iceandfire.render.model.HydraHeadModel;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class HydraHeadFeatureRenderer
extends RenderLayer<HydraEntity, HydraBodyModel> {
    public static final ResourceLocation TEXTURE_STONE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/hydra/stone.png");
    private static final float[][] TRANSLATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.15f, 0.15f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.3f, 0.0f, 0.3f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.4f, -0.1f, 0.1f, 0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.5f, -0.2f, 0.0f, 0.2f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.0f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.1f, 0.2f, 0.4f, 0.6f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.0f, 0.1f, 0.2f, 0.4f, 0.6f}};
    private static final float[][] ROTATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, 0.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {25.0f, 10.0f, -10.0f, -25.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {30.0f, 15.0f, 0.0f, -15.0f, -30.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 25.0f, 5.0f, -5.0f, -25.0f, -40.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 30.0f, 15.0f, 0.0f, -15.0f, -30.0f, -40.0f, 0.0f, 0.0f}, {45.0f, 30.0f, 20.0f, 5.0f, -5.0f, -20.0f, -30.0f, -45.0f, 0.0f}, {50.0f, 37.0f, 25.0f, 15.0f, 0.0f, -15.0f, -25.0f, -37.0f, -50.0f}};
    private static final HydraHeadModel[] modelArr = new HydraHeadModel[9];
    private final HydraEntityRenderer renderer;

    public HydraHeadFeatureRenderer(HydraEntityRenderer renderer) {
        super((RenderLayerParent)renderer);
        this.renderer = renderer;
    }

    public static void renderHydraHeads(HydraBodyModel model, boolean stone, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, HydraEntity hydra, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.pushPose();
        int heads = hydra.getHeadCount();
        HydraHeadFeatureRenderer.translateToBody(model, matrixStackIn);
        RenderType type = RenderType.entityCutout((ResourceLocation)(stone ? TEXTURE_STONE : HydraHeadFeatureRenderer.getHeadTexture(hydra)));
        for (int head = 1; head <= heads; ++head) {
            matrixStackIn.pushPose();
            float bodyWidth = 0.5f;
            matrixStackIn.translate(TRANSLATE[heads - 1][head - 1] * bodyWidth, 0.0f, 0.0f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(ROTATE[heads - 1][head - 1]));
            modelArr[head - 1].setAngles(hydra, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            modelArr[head - 1].renderToBuffer(matrixStackIn, bufferIn.getBuffer(type), packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)hydra, (float)0.0f), -1);
            matrixStackIn.popPose();
        }
        matrixStackIn.popPose();
    }

    public static ResourceLocation getHeadTexture(HydraEntity gorgon) {
        return switch (gorgon.getVariant()) {
            case 1 -> HydraEntityRenderer.TEXUTURE_1;
            case 2 -> HydraEntityRenderer.TEXUTURE_2;
            default -> HydraEntityRenderer.TEXUTURE_0;
        };
    }

    protected static void translateToBody(HydraBodyModel model, PoseStack stack) {
        HydraHeadFeatureRenderer.postRender(model.BodyUpper, stack);
    }

    protected static void postRender(AdvancedModelBox renderer, PoseStack matrixStackIn) {
        if (renderer.rotateAngleX == 0.0f && renderer.rotateAngleY == 0.0f && renderer.rotateAngleZ == 0.0f) {
            if (renderer.rotationPointX != 0.0f || renderer.rotationPointY != 0.0f) {
                matrixStackIn.translate(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotateAngleZ * 0.0625f);
            }
        } else {
            matrixStackIn.translate(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotateAngleZ * 0.0625f);
            if (renderer.rotateAngleZ != 0.0f) {
                matrixStackIn.mulPose(Axis.ZP.rotation(renderer.rotateAngleZ));
            }
            if (renderer.rotateAngleY != 0.0f) {
                matrixStackIn.mulPose(Axis.YP.rotation(renderer.rotateAngleY));
            }
            if (renderer.rotateAngleX != 0.0f) {
                matrixStackIn.mulPose(Axis.XP.rotation(renderer.rotateAngleX));
            }
        }
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, HydraEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.isInvisible()) {
            return;
        }
        HydraHeadFeatureRenderer.renderHydraHeads((HydraBodyModel)this.renderer.getModel(), false, matrixStackIn, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
    }

    public ResourceLocation getTexture(HydraEntity gorgon) {
        return switch (gorgon.getVariant()) {
            case 1 -> HydraEntityRenderer.TEXUTURE_1;
            case 2 -> HydraEntityRenderer.TEXUTURE_2;
            default -> HydraEntityRenderer.TEXUTURE_0;
        };
    }

    static {
        for (int i = 0; i < modelArr.length; ++i) {
            HydraHeadFeatureRenderer.modelArr[i] = new HydraHeadModel(i);
        }
    }
}

