/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.entity.DragonEggEntity;
import com.iafenvoy.iceandfire.item.block.entity.EggInIceBlockEntity;
import com.iafenvoy.uranus.client.model.AdvancedEntityModel;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;

public class DragonEggModel
extends AdvancedEntityModel<DragonEggEntity> {
    public final AdvancedModelBox Egg1;
    public final AdvancedModelBox Egg2;
    public final AdvancedModelBox Egg3;
    public final AdvancedModelBox Egg4;

    public DragonEggModel() {
        this.texWidth = 64;
        this.texHeight = 32;
        this.Egg3 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.Egg3.setPos(0.0f, 0.0f, 0.0f);
        this.Egg3.addBox(-2.5f, -4.6f, -2.5f, 5.0f, 5.0f, 5.0f, 0.0f);
        this.Egg2 = new AdvancedModelBox((AdvancedEntityModel)this, 22, 2);
        this.Egg2.setPos(0.0f, 0.0f, 0.0f);
        this.Egg2.addBox(-2.5f, -0.6f, -2.5f, 5.0f, 5.0f, 5.0f, 0.0f);
        this.Egg1 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 12);
        this.Egg1.setPos(0.0f, 19.6f, 0.0f);
        this.Egg1.addBox(-3.0f, -2.8f, -3.0f, 6.0f, 6.0f, 6.0f, 0.0f);
        this.Egg4 = new AdvancedModelBox((AdvancedEntityModel)this, 28, 16);
        this.Egg4.setPos(0.0f, -0.9f, 0.0f);
        this.Egg4.addBox(-2.0f, -4.8f, -2.0f, 4.0f, 4.0f, 4.0f, 0.0f);
        this.Egg1.addChild((BasicModelPart)this.Egg3);
        this.Egg1.addChild((BasicModelPart)this.Egg2);
        this.Egg3.addChild((BasicModelPart)this.Egg4);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.Egg1);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.Egg1, (Object)this.Egg2, (Object)this.Egg3, (Object)this.Egg4);
    }

    public void setAngles(DragonEggEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        DragonEggEntity egg;
        this.resetToDefaultPose();
        this.Egg1.setPos(0.0f, 19.6f, 0.0f);
        this.Egg4.setPos(0.0f, -0.9f, 0.0f);
        if (entity instanceof DragonEggEntity && (egg = entity).isLocationValid()) {
            this.walk(this.Egg1, 0.3f, 0.3f, true, 1.0f, 0.0f, animationProgress, 1.0f);
            this.flap(this.Egg1, 0.3f, 0.3f, false, 0.0f, 0.0f, animationProgress, 1.0f);
        }
    }

    public void renderPodium() {
        this.Egg1.rotateAngleX = (float)Math.toRadians(-180.0);
    }

    public void renderFrozen(EggInIceBlockEntity tile) {
        this.resetToDefaultPose();
        this.Egg1.rotateAngleX = (float)Math.toRadians(-180.0);
        this.walk(this.Egg1, 0.3f, 0.1f, true, 1.0f, 0.0f, tile.ticksExisted, 1.0f);
        this.flap(this.Egg1, 0.3f, 0.1f, false, 0.0f, 0.0f, tile.ticksExisted, 1.0f);
    }
}

