/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen.handler;

import com.iafenvoy.iceandfire.data.BestiaryPage;
import com.iafenvoy.iceandfire.item.BestiaryItem;
import com.iafenvoy.iceandfire.item.block.entity.LecternBlockEntity;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafRegistries;
import com.iafenvoy.iceandfire.registry.IafScreenHandlers;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.screen.slot.LecternSlot;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class LecternScreenHandler
extends AbstractContainerMenu {
    private final Container tileFurnace;
    private final int[] possiblePagesInt = new int[3];
    private final ContainerData propertyDelegate;

    public LecternScreenHandler(int i, Inventory playerInventory) {
        this(i, (Container)new SimpleContainer(2), playerInventory, (ContainerData)new SimpleContainerData(3));
    }

    public LecternScreenHandler(int id, Container furnaceInventory, Inventory playerInventory, ContainerData propertyDelegate) {
        super((MenuType)IafScreenHandlers.IAF_LECTERN_SCREEN.get(), id);
        this.tileFurnace = furnaceInventory;
        this.propertyDelegate = propertyDelegate;
        this.addDataSlots(propertyDelegate);
        this.addSlot(new LecternSlot(this, furnaceInventory, 0, 15, 47){

            public boolean mayPlace(ItemStack stack) {
                return super.mayPlace(stack) && !stack.isEmpty() && stack.getItem() instanceof BestiaryItem;
            }
        });
        this.addSlot(new Slot(this, furnaceInventory, 1, 35, 47){

            public boolean mayPlace(ItemStack stack) {
                return super.mayPlace(stack) && !stack.isEmpty() && stack.getItem() == IafItems.MANUSCRIPT.get();
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }

    private int getPageField(int i) {
        return this.propertyDelegate.get(i);
    }

    public void onUpdate() {
        this.possiblePagesInt[0] = this.getPageField(0);
        this.possiblePagesInt[1] = this.getPageField(1);
        this.possiblePagesInt[2] = this.getPageField(2);
    }

    public boolean stillValid(Player playerIn) {
        return this.tileFurnace.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.tileFurnace.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.tileFurnace.getContainerSize(), this.slots.size(), true) : (this.getSlot(0).mayPlace(itemstack1) && !this.getSlot(0).hasItem() ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (this.getSlot(1).mayPlace(itemstack1) && !this.getSlot(1).hasItem() ? !this.moveItemStackTo(itemstack1, 1, 2, false) : this.tileFurnace.getContainerSize() <= 5 || !this.moveItemStackTo(itemstack1, 5, this.tileFurnace.getContainerSize(), false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public BestiaryPage[] getPossiblePages() {
        this.possiblePagesInt[0] = this.getPageField(0);
        this.possiblePagesInt[1] = this.getPageField(1);
        this.possiblePagesInt[2] = this.getPageField(2);
        BestiaryPage[] pages = new BestiaryPage[3];
        List allPages = IafRegistries.BESTIARY_PAGE.stream().toList();
        if (this.tileFurnace.getItem(0).getItem() == IafItems.BESTIARY.get()) {
            pages[0] = this.possiblePagesInt[0] < 0 ? null : (BestiaryPage)allPages.get(Math.min(allPages.size(), this.possiblePagesInt[0]));
            pages[1] = this.possiblePagesInt[1] < 0 ? null : (BestiaryPage)allPages.get(Math.min(allPages.size(), this.possiblePagesInt[1]));
            pages[2] = this.possiblePagesInt[2] < 0 ? null : (BestiaryPage)allPages.get(Math.min(allPages.size(), this.possiblePagesInt[2]));
        }
        return pages;
    }

    public boolean clickMenuButton(Player playerIn, int id) {
        this.onUpdate();
        ItemStack bookStack = this.tileFurnace.getItem(0);
        ItemStack manuscriptStack = this.tileFurnace.getItem(1);
        int i = 3;
        if (manuscriptStack.isEmpty() || manuscriptStack.getCount() < i || manuscriptStack.getItem() != IafItems.MANUSCRIPT.get()) {
            return false;
        }
        if (this.possiblePagesInt[id] > 0 && !bookStack.isEmpty() && bookStack.getItem() == IafItems.BESTIARY.get()) {
            BestiaryPage page = this.getPossiblePages()[Mth.clamp((int)id, (int)0, (int)2)];
            if (page != null) {
                if (!playerIn.level().isClientSide) {
                    manuscriptStack.shrink(i);
                    if (manuscriptStack.isEmpty()) {
                        this.tileFurnace.setItem(1, ItemStack.EMPTY);
                    }
                    BestiaryPage.addPage(page, bookStack);
                    Container container = this.tileFurnace;
                    if (container instanceof LecternBlockEntity) {
                        LecternBlockEntity entityLectern = (LecternBlockEntity)container;
                        entityLectern.randomizePages(bookStack, manuscriptStack);
                    }
                }
                this.tileFurnace.setItem(0, bookStack);
                this.tileFurnace.setChanged();
                this.slotsChanged(this.tileFurnace);
                playerIn.level().playSound(null, playerIn.blockPosition(), (SoundEvent)IafSounds.BESTIARY_PAGE.get(), SoundSource.BLOCKS, 1.0f, playerIn.level().random.nextFloat() * 0.1f + 0.9f);
            }
            this.onUpdate();
            return true;
        }
        return false;
    }
}

