/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen.slot;

import com.iafenvoy.iceandfire.data.DragonArmorPart;
import com.iafenvoy.iceandfire.item.DragonArmorItem;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DragonArmorSlot
extends Slot {
    private final DragonArmorPart expectedArmor;

    public DragonArmorSlot(Container inventory, int index, int x, int y, DragonArmorPart expectedArmor) {
        super(inventory, index, x, y);
        this.expectedArmor = expectedArmor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mayPlace(ItemStack stack) {
        if (!super.mayPlace(stack)) return false;
        if (stack.isEmpty()) return false;
        Item item = stack.getItem();
        if (!(item instanceof DragonArmorItem)) return false;
        DragonArmorItem armor = (DragonArmorItem)item;
        if (armor.dragonSlot != this.expectedArmor) return false;
        return true;
    }

    public int getMaxStackSize() {
        return 1;
    }
}

