/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.feature;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.DeathWormEntity;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.world.DangerousGeneration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DeathWormSpawnFeature
extends Feature<NoneFeatureConfiguration>
implements DangerousGeneration {
    public DeathWormSpawnFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos;
        WorldGenLevel world = context.level();
        if (this.isFarEnoughFromSpawn((LevelAccessor)world, pos = world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, context.origin().offset(8, 0, 8))) && context.random().nextDouble() < (Double)IafCommonConfig.INSTANCE.deathworm.spawnChance.getValue()) {
            DeathWormEntity deathWorm = (DeathWormEntity)((EntityType)IafEntities.DEATH_WORM.get()).create((Level)world.getLevel());
            assert (deathWorm != null);
            deathWorm.setPos((float)pos.getX() + 0.5f, pos.getY() + 1, (float)pos.getZ() + 0.5f);
            deathWorm.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(pos), MobSpawnType.CHUNK_GENERATION, null);
            world.addFreshEntity((Entity)deathWorm);
        }
        return true;
    }
}

