/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.feature;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.CyclopsEntity;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.world.DangerousGeneration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WanderingCyclopsSpawnFeature
extends Feature<NoneFeatureConfiguration>
implements DangerousGeneration {
    public WanderingCyclopsSpawnFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        BlockPos pos = world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, context.origin().offset(8, 0, 8));
        if (this.isFarEnoughFromSpawn((LevelAccessor)world, pos) && random.nextDouble() < (Double)IafCommonConfig.INSTANCE.cyclops.spawnWanderingChance.getValue() && random.nextInt(12) == 0) {
            CyclopsEntity cyclops = (CyclopsEntity)((EntityType)IafEntities.CYCLOPS.get()).create((Level)world.getLevel());
            assert (cyclops != null);
            cyclops.setPos((float)pos.getX() + 0.5f, pos.getY() + 1, (float)pos.getZ() + 0.5f);
            cyclops.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(pos), MobSpawnType.SPAWNER, null);
            world.addFreshEntity((Entity)cyclops);
            for (int i = 0; i < 3 + random.nextInt(3); ++i) {
                Sheep sheep = (Sheep)EntityType.SHEEP.create((Level)world.getLevel());
                assert (sheep != null);
                sheep.setPos((double)((float)pos.getX() + 0.5f), (double)(pos.getY() + 1), (double)((float)pos.getZ() + 0.5f));
                sheep.setColor(Sheep.getRandomSheepColor((RandomSource)random));
                world.addFreshEntity((Entity)sheep);
            }
        }
        return true;
    }
}

