/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.compat.emi;

import com.iafenvoy.iceandfire.recipe.DragonForgeRecipe;
import com.iafenvoy.iceandfire.registry.IafRecipes;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class ForgeRecipeHolder {
    private final String dragonType;
    private final EmiTexture texture;
    private final EmiStack workstation;
    private final EmiRecipeCategory category;

    public ForgeRecipeHolder(class_2960 id, String dragonType, EmiTexture texture, EmiStack workstation) {
        this.dragonType = dragonType;
        this.texture = texture;
        this.workstation = workstation;
        this.category = new EmiRecipeCategory(id, (EmiRenderable)workstation, (EmiRenderable)texture);
    }

    public void register(EmiRegistry registry) {
        registry.addCategory(this.category);
        registry.addWorkstation(this.category, (EmiIngredient)this.workstation);
        List forgeRecipeList = registry.getRecipeManager().method_30027((class_3956)IafRecipes.DRAGON_FORGE_TYPE.get());
        for (class_8786 recipeEntry : forgeRecipeList.stream().filter(entry -> ((DragonForgeRecipe)entry.comp_1933()).getDragonType().equals(this.dragonType)).toList()) {
            registry.addRecipe((EmiRecipe)new DragonForgeEmiRecipe((class_8786<DragonForgeRecipe>)recipeEntry, this.category));
        }
    }

    public class DragonForgeEmiRecipe
    implements EmiRecipe {
        private final class_8786<DragonForgeRecipe> entry;
        private final EmiRecipeCategory category;

        public DragonForgeEmiRecipe(class_8786<DragonForgeRecipe> entry, EmiRecipeCategory category) {
            this.entry = entry;
            this.category = category;
        }

        public EmiRecipeCategory getCategory() {
            return this.category;
        }

        @Nullable
        public class_2960 getId() {
            return this.entry.comp_1932();
        }

        public List<EmiIngredient> getInputs() {
            return List.of(EmiIngredient.of((class_1856)((DragonForgeRecipe)this.entry.comp_1933()).getInput()), EmiIngredient.of((class_1856)((DragonForgeRecipe)this.entry.comp_1933()).getBlood()));
        }

        public List<EmiStack> getOutputs() {
            return List.of(EmiStack.of((class_1799)((DragonForgeRecipe)this.entry.comp_1933()).getResultItem()));
        }

        public int getDisplayWidth() {
            return 176;
        }

        public int getDisplayHeight() {
            return 1120;
        }

        public void addWidgets(WidgetHolder widgets) {
            widgets.addTexture(ForgeRecipeHolder.this.texture, 3, 4);
            widgets.addSlot(EmiIngredient.of((class_1856)((DragonForgeRecipe)this.entry.comp_1933()).getInput()), 67, 33);
            widgets.addSlot(EmiIngredient.of((class_1856)((DragonForgeRecipe)this.entry.comp_1933()).getBlood()), 85, 33);
            widgets.addSlot((EmiIngredient)EmiStack.of((class_1799)((DragonForgeRecipe)this.entry.comp_1933()).getResultItem()), 143, 30).large(true).recipeContext((EmiRecipe)this);
        }
    }
}

