/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.compat.ponder;

import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.item.block.DragonForgeBrickBlock;
import com.iafenvoy.uranus.util.RandomHelper;
import java.util.function.Function;
import net.createmod.ponder.api.scene.PonderStoryBoard;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class DragonForgeStoryBoard<T extends DragonBaseEntity>
implements PonderStoryBoard {
    private final Function<class_1937, class_1297> dragonFactory;
    private final Class<T> dragonClass;

    public DragonForgeStoryBoard(Function<class_1937, class_1297> dragonFactory, Class<T> dragonClass) {
        this.dragonFactory = dragonFactory;
        this.dragonClass = dragonClass;
    }

    public static class_2960 id(DragonType type) {
        return class_2960.method_60655((String)"iceandfire", (String)"%s_dragon_forge".formatted(type.name()));
    }

    public void program(@NotNull SceneBuilder scene, @NotNull SceneBuildingUtil util) {
        class_2338 center = new class_2338(2, 2, 2);
        scene.title("dragon_forge", "Dragon Forge");
        scene.configureBasePlate(0, 0, 5);
        scene.removeShadow();
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(20);
        scene.world().showSection(util.select().layer(1), class_2350.field_11033);
        scene.idle(20);
        scene.world().showSection(util.select().layer(2), class_2350.field_11033);
        DragonForgeStoryBoard.setBrickDisplay(scene, center, false);
        scene.idle(15);
        DragonForgeStoryBoard.setBrickDisplay(scene, center, false);
        scene.idle(5);
        scene.overlay().showText(50).text("This is the core of forge, all items put in here").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(center, class_2350.field_11036));
        scene.idle(60);
        scene.overlay().showText(50).text("Dragon need to see this block to power the forge").placeNearTarget().pointAt(util.vector().blockSurface(center.method_10095(), class_2350.field_11036));
        scene.idle(60);
        scene.world().showSection(util.select().layer(3), class_2350.field_11033);
        scene.idle(20);
        DragonForgeStoryBoard.setBrickDisplay(scene, center, true);
        scene.rotateCameraY(-45.0f);
        scene.idle(20);
        scene.world().createEntity(this.dragonFactory);
        scene.world().modifyEntities(this.dragonClass, dragon -> class_310.method_1551().execute(() -> {
            dragon.setGender(true);
            dragon.setVariant(((DragonColor)RandomHelper.randomOne(dragon.dragonType.colors())).getName());
            dragon.method_23327(3.0, 0.5, -5.0);
            dragon.setAgeInDays(50);
            dragon.method_24346(true);
            dragon.setAnimation(DragonBaseEntity.ANIMATION_SPEAK);
        }));
        scene.overlay().showText(100).text("You need the correct type of dragon to power the forge").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(new class_2338(0, 2, -5), class_2350.field_11036));
        scene.overlay().showText(100).text("You can use blocks at the center of each face to open the forge").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(center.method_10067(), class_2350.field_11039));
    }

    private static void setBrickDisplay(SceneBuilder scene, class_2338 center, boolean bl) {
        for (int i = 0; i < 4; ++i) {
            scene.world().modifyBlock(center.method_10081(class_2350.method_10139((int)i).method_10163()), state -> state.method_28498((class_2769)DragonForgeBrickBlock.GRILL) ? (class_2680)state.method_11657((class_2769)DragonForgeBrickBlock.GRILL, (Comparable)Boolean.valueOf(bl)) : state, false);
        }
    }
}

