/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.item.armor.TrollArmorItem;
import com.iafenvoy.iceandfire.item.tool.TrollWeaponItem;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafRegistries;
import com.iafenvoy.uranus.util.RandomHelper;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;

public class TrollType {
    public RegistrySupplier<class_1792> leather;
    public RegistrySupplier<class_1792> helmet;
    public RegistrySupplier<class_1792> chestplate;
    public RegistrySupplier<class_1792> leggings;
    public RegistrySupplier<class_1792> boots;
    private final String name;
    private final class_6880<class_1741> material;
    private final class_6862<class_1959> spawnBiomes;
    private final class_2960 lootTable;
    private final List<ITrollWeapon> weapons;

    public TrollType(String name, class_6880<class_1741> material, class_6862<class_1959> spawnBiomes, ITrollWeapon ... weapons) {
        this.name = name;
        this.weapons = List.of(weapons);
        this.material = material;
        this.spawnBiomes = spawnBiomes;
        this.lootTable = class_2960.method_60655((String)"iceandfire", (String)("entities/troll_" + name));
    }

    public static TrollType getBiomeType(class_6880<class_1959> biome) {
        List<TrollType> types = IafRegistries.TROLL_TYPE.method_10220().filter(x -> x.allowSpawn(biome)).toList();
        return (TrollType)RandomHelper.randomOne(types.isEmpty() ? IafRegistries.TROLL_TYPE.method_10220().toList() : types);
    }

    public static ITrollWeapon getWeaponForType(TrollType troll) {
        return troll.weapons.get(ThreadLocalRandom.current().nextInt(troll.weapons.size()));
    }

    public static void initArmors() {
        for (TrollType troll : IafRegistries.TROLL_TYPE) {
            troll.leather = IafItems.registerItem("troll_leather_%s".formatted(troll.name.toLowerCase(Locale.ROOT)), () -> new class_1792(new class_1792.class_1793()));
            troll.helmet = IafItems.registerArmor(TrollArmorItem.getName(troll, class_1738.class_8051.field_41934), () -> new TrollArmorItem(troll, class_1738.class_8051.field_41934));
            troll.chestplate = IafItems.registerArmor(TrollArmorItem.getName(troll, class_1738.class_8051.field_41935), () -> new TrollArmorItem(troll, class_1738.class_8051.field_41935));
            troll.leggings = IafItems.registerArmor(TrollArmorItem.getName(troll, class_1738.class_8051.field_41936), () -> new TrollArmorItem(troll, class_1738.class_8051.field_41936));
            troll.boots = IafItems.registerArmor(TrollArmorItem.getName(troll, class_1738.class_8051.field_41937), () -> new TrollArmorItem(troll, class_1738.class_8051.field_41937));
        }
    }

    public static List<TrollType> values() {
        return IafRegistries.TROLL_TYPE.method_10220().toList();
    }

    public static TrollType getByName(String name) {
        return (TrollType)IafRegistries.TROLL_TYPE.method_10223(IceAndFire.id(name));
    }

    public String getName() {
        return this.name;
    }

    public class_2960 getLootTable() {
        return this.lootTable;
    }

    public class_6880<class_1741> getMaterial() {
        return this.material;
    }

    public class_2960 getTexture() {
        return class_2960.method_60655((String)"iceandfire", (String)("textures/entity/troll/troll_" + this.name + ".png"));
    }

    public class_2960 getStatueTexture() {
        return class_2960.method_60655((String)"iceandfire", (String)("textures/entity/troll/troll_" + this.name + "_stone.png"));
    }

    public class_2960 getEyesTexture() {
        return class_2960.method_60655((String)"iceandfire", (String)("textures/entity/troll/troll_" + this.name + "_eyes.png"));
    }

    public boolean allowSpawn(class_6880<class_1959> biome) {
        return biome.method_40220(this.spawnBiomes);
    }

    public static interface ITrollWeapon {
        @ApiStatus.Internal
        public static final List<ITrollWeapon> WEAPONS = new ArrayList<ITrollWeapon>();
        @ApiStatus.Internal
        public static final Map<String, ITrollWeapon> BY_NAME = new HashMap<String, ITrollWeapon>();

        public static void addWeapons(ITrollWeapon ... weapons) {
            for (ITrollWeapon weapon : weapons) {
                WEAPONS.add(weapon);
                BY_NAME.put(weapon.getName(), weapon);
            }
        }

        public static List<ITrollWeapon> values() {
            return ImmutableList.copyOf(WEAPONS);
        }

        public static ITrollWeapon getByName(String name) {
            return BY_NAME.getOrDefault(name, BuiltinWeapon.AXE);
        }

        public String getName();

        public class_2960 getTexture();

        public class_1792 getItem();
    }

    public static enum BuiltinWeapon implements ITrollWeapon
    {
        AXE,
        COLUMN,
        COLUMN_FOREST,
        COLUMN_FROST,
        HAMMER,
        TRUNK,
        TRUNK_FROST;

        private final RegistrySupplier<class_1792> item = IafItems.registerToolOrWeapon("troll_weapon_" + this.name().toLowerCase(Locale.ROOT), () -> new TrollWeaponItem(this));

        private BuiltinWeapon() {
            ITrollWeapon.addWeapons(this);
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public class_2960 getTexture() {
            return class_2960.method_60655((String)"iceandfire", (String)("textures/entity/troll/weapon/weapon_" + this.name().toLowerCase(Locale.ROOT) + ".png"));
        }

        @Override
        public class_1792 getItem() {
            return (class_1792)this.item.get();
        }
    }
}

