/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.impl.ComponentManager;
import com.iafenvoy.iceandfire.util.attachment.NeedUpdateData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_4844;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class MiscData
extends NeedUpdateData<class_1309> {
    public static final Codec<MiscData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("loveTicks").forGetter(MiscData::getLoveTicks), (App)Codec.INT.fieldOf("lungeTicks").forGetter(MiscData::getLungeTicks), (App)class_4844.field_40825.listOf().fieldOf("targetedByScepters").forGetter(MiscData::getTargetedByScepters)).apply((Applicative)i, MiscData::new));
    public static final class_9139<class_9129, MiscData> PACKET_CODEC = class_9135.method_56896(CODEC);
    public int loveTicks;
    public int lungeTicks;
    private final List<UUID> targetedByScepters = new LinkedList<UUID>();

    public MiscData() {
    }

    private MiscData(int loveTicks, int lungeTicks, List<UUID> targetedByScepters) {
        this.loveTicks = loveTicks;
        this.lungeTicks = lungeTicks;
        this.targetedByScepters.addAll(targetedByScepters);
    }

    @Override
    public void tick(class_1309 entity) {
        if (this.loveTicks > 0) {
            --this.loveTicks;
            if (this.loveTicks == 0) {
                this.markDirty();
                if (entity instanceof class_1308) {
                    class_1308 mob = (class_1308)entity;
                    mob.method_5942().method_6356();
                }
                return;
            }
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                mob.method_29505(null);
                mob.method_6015(null);
                mob.method_5980(null);
                mob.method_19540(false);
                mob.method_5942().method_6340();
            }
            this.createLoveParticles(entity);
        }
    }

    public void addScepterTarget(class_1309 target) {
        UUID uuid = target.method_5667();
        if (!this.targetedByScepters.contains(uuid)) {
            this.targetedByScepters.add(uuid);
            this.markDirty();
        }
    }

    public void checkScepterTarget(Function<UUID, class_1297> entityGetter) {
        this.targetedByScepters.removeIf(uuid -> {
            class_1309 living;
            Object patt0$temp = entityGetter.apply((UUID)uuid);
            return patt0$temp instanceof class_1309 && ((living = (class_1309)patt0$temp).method_31481() || living.method_6112(class_1294.field_5920) == null || living.method_6112(class_1294.field_5920).method_5584() <= 0);
        });
    }

    public void setLoveTicks(int loveTicks) {
        this.loveTicks = loveTicks;
        this.markDirty();
    }

    public void setLungeTicks(int lungeTicks) {
        this.lungeTicks = lungeTicks;
        this.markDirty();
    }

    private void createLoveParticles(class_1309 entity) {
        if (entity.method_59922().method_43048(7) == 0) {
            for (int i = 0; i < 5; ++i) {
                entity.method_37908().method_8406((class_2394)class_2398.field_11201, entity.method_23317() + (entity.method_59922().method_43058() - 0.5) * 3.0, entity.method_23318() + (entity.method_59922().method_43058() - 0.5) * 3.0, entity.method_23321() + (entity.method_59922().method_43058() - 0.5) * 3.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public int getLoveTicks() {
        return this.loveTicks;
    }

    public int getLungeTicks() {
        return this.lungeTicks;
    }

    public List<UUID> getTargetedByScepters() {
        return this.targetedByScepters;
    }

    public static MiscData get(class_1309 living) {
        return ComponentManager.getMiscData(living);
    }
}

