/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.util.BlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.IDeadMob;
import com.iafenvoy.iceandfire.item.DragonEggItem;
import com.iafenvoy.iceandfire.item.block.entity.EggInIceBlockEntity;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafDragonColors;
import com.iafenvoy.iceandfire.registry.IafDragonTypes;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.object.BlockUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3321;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import net.minecraft.server.MinecraftServer;

public class DragonEggEntity
extends class_1309
implements BlacklistedFromStatues,
IDeadMob {
    protected static final class_2940<Optional<UUID>> OWNER_UNIQUE_ID = class_2945.method_12791(DragonEggEntity.class, (class_2941)class_2943.field_13313);
    private static final Map<DragonType, EggTicker> TICKERS = new LinkedHashMap<DragonType, EggTicker>();
    private static final class_2940<String> DRAGON_TYPE = class_2945.method_12791(DragonEggEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Integer> DRAGON_AGE = class_2945.method_12791(DragonEggEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> LOCATION_VALID = class_2945.method_12791(DragonEggEntity.class, (class_2941)class_2943.field_13323);

    public DragonEggEntity(class_1299<DragonEggEntity> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.0);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10582("Color", this.getEggType().getName());
        tag.method_10569("DragonAge", this.getDragonAge());
        try {
            if (this.getOwnerId() == null) {
                tag.method_10582("OwnerUUID", "");
            } else {
                tag.method_10582("OwnerUUID", this.getOwnerId().toString());
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.error("An error occurred while trying to read the NBT data of a dragon egg", (Throwable)e);
        }
    }

    public void method_5749(class_2487 tag) {
        String s;
        super.method_5749(tag);
        this.setEggType(DragonColor.getById(tag.method_10558("Color")));
        this.setDragonAge(tag.method_10550("DragonAge"));
        if (tag.method_10573("OwnerUUID", 8)) {
            s = tag.method_10558("OwnerUUID");
        } else {
            String s1 = tag.method_10558("Owner");
            UUID converedUUID = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)s1);
            String string = s = converedUUID == null ? s1 : converedUUID.toString();
        }
        if (!s.isEmpty()) {
            this.setOwnerId(UUID.fromString(s));
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DRAGON_TYPE, (Object)IafDragonColors.RED.toString());
        builder.method_56912(DRAGON_AGE, (Object)0);
        builder.method_56912(OWNER_UNIQUE_ID, Optional.empty());
        builder.method_56912(LOCATION_VALID, (Object)false);
    }

    public boolean method_5679(class_1282 i) {
        return i.method_5529() != null && super.method_5679(i);
    }

    public DragonColor getEggType() {
        return DragonColor.getById((String)this.method_5841().method_12789(DRAGON_TYPE));
    }

    public void setEggType(DragonColor color) {
        this.method_5841().method_12778(DRAGON_TYPE, (Object)color.getName());
    }

    public int getDragonAge() {
        return (Integer)this.method_5841().method_12789(DRAGON_AGE);
    }

    public void setDragonAge(int i) {
        this.method_5841().method_12778(DRAGON_AGE, (Object)i);
    }

    public UUID getOwnerId() {
        return ((Optional)this.field_6011.method_12789(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(UUID uuid) {
        this.field_6011.method_12778(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public boolean isLocationValid() {
        return (Boolean)this.field_6011.method_12789(LOCATION_VALID);
    }

    public void setLocationValid(boolean valid) {
        this.field_6011.method_12778(LOCATION_VALID, (Object)valid);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && !this.method_31481()) {
            this.method_5855(200);
            this.updateEggCondition();
        }
    }

    public void updateEggCondition() {
        boolean hatched;
        DragonType dragonType = this.getEggType().getType();
        EggTicker ticker = TICKERS.get(dragonType);
        boolean bl = hatched = this.getDragonAge() > (Integer)IafCommonConfig.INSTANCE.dragon.eggBornTime.getValue();
        if (ticker != null) {
            this.setLocationValid(ticker.tick(this, this.method_37908(), this.method_24515(), hatched));
        }
        if (hatched) {
            this.method_37908().method_8501(this.method_24515(), class_2246.field_10124.method_9564());
            DragonBaseEntity dragon = dragonType.createEntity(this.method_37908());
            assert (dragon != null);
            dragon.setVariant(this.getEggType().getName());
            dragon.setGender(this.method_59922().method_43056());
            dragon.method_5814((double)this.method_24515().method_10263() + 0.5, this.method_24515().method_10264() + 1, (double)this.method_24515().method_10260() + 0.5);
            dragon.setHunger(50);
            if (!this.method_37908().method_8608()) {
                this.method_37908().method_8649((class_1297)dragon);
            }
            if (this.method_16914()) {
                dragon.method_5665(this.method_5797());
            }
            dragon.method_6173(true, true);
            dragon.method_6174(this.getOwnerId());
            this.method_37908().method_8486(this.method_23317(), this.method_23318() + (double)this.method_5751(), this.method_23321(), (class_3414)IafSounds.EGG_HATCH.get(), this.method_5634(), 2.5f, 1.0f, false);
            this.method_31472();
        }
    }

    public class_3414 method_6011(class_1282 damageSourceIn) {
        return null;
    }

    public Iterable<class_1799> method_5661() {
        return ImmutableList.of();
    }

    public class_1799 method_6118(class_1304 slotIn) {
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slotIn, class_1799 stack) {
    }

    public boolean method_5643(class_1282 var1, float var2) {
        if (var1.method_48789(class_8103.field_42246) && this.getEggType().getType() == IafDragonTypes.FIRE) {
            return false;
        }
        if (!(this.method_37908().field_9236 || var1.method_48789(class_8103.field_42242) || this.method_31481())) {
            this.method_5870((class_1935)this.getItem().method_7909(), 1);
        }
        this.method_5650(class_1297.class_5529.field_26998);
        return true;
    }

    private class_1799 getItem() {
        return new class_1799((class_1935)DragonEggItem.EGGS.getOrDefault(this.getEggType(), class_1802.field_8162));
    }

    public boolean method_5810() {
        return false;
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    protected void method_6087(class_1297 entity) {
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public void onPlayerPlace(class_1657 player) {
        this.setOwnerId(player.method_5667());
    }

    @Override
    public boolean isMobDead() {
        return true;
    }

    public static void register(DragonType type, EggTicker ticker) {
        TICKERS.put(type, ticker);
    }

    static {
        DragonEggEntity.register(IafDragonTypes.FIRE, (entity, world, pos, hatched) -> {
            boolean valid = BlockUtil.isBurning((class_2680)world.method_8320(pos));
            if (valid) {
                entity.setDragonAge(entity.getDragonAge() + 1);
            }
            if (hatched) {
                world.method_8486(entity.method_23317(), entity.method_23318() + (double)entity.method_5751(), entity.method_23321(), class_3417.field_15102, entity.method_5634(), 2.5f, 1.0f, false);
            }
            return valid;
        });
        DragonEggEntity.register(IafDragonTypes.ICE, (entity, world, pos, hatched) -> {
            class_2680 state = world.method_8320(pos);
            if (state.method_27852(class_2246.field_10382) && entity.method_59922().method_43048(500) == 0) {
                world.method_8501(pos, ((class_2248)IafBlocks.EGG_IN_ICE.get()).method_9564());
                world.method_8486(entity.method_23317(), entity.method_23318() + (double)entity.method_5751(), entity.method_23321(), class_3417.field_15081, entity.method_5634(), 2.5f, 1.0f, false);
                class_2586 patt0$temp = world.method_8321(pos);
                if (patt0$temp instanceof EggInIceBlockEntity) {
                    EggInIceBlockEntity eggInIce = (EggInIceBlockEntity)patt0$temp;
                    eggInIce.type = entity.getEggType();
                    eggInIce.ownerUUID = entity.getOwnerId();
                }
                entity.method_5650(class_1297.class_5529.field_26999);
            }
            return false;
        });
        DragonEggEntity.register(IafDragonTypes.LIGHTNING, (entity, world, pos, hatched) -> {
            boolean valid;
            boolean isRainingAt = world.method_8520(pos) || world.method_8520(class_2338.method_49637((double)entity.method_23317(), (double)(entity.method_23318() + (double)entity.method_17682()), (double)entity.method_23321()));
            boolean bl = valid = world.method_8311(pos.method_10084()) && isRainingAt;
            if (valid) {
                entity.setDragonAge(entity.getDragonAge() + 1);
            }
            if (hatched) {
                class_1538 bolt = (class_1538)class_1299.field_6112.method_5883(world);
                assert (bolt != null);
                bolt.method_5814(entity.method_23317(), entity.method_23318(), entity.method_23321());
                bolt.method_29498(true);
                if (!world.field_9236) {
                    world.method_8649((class_1297)bolt);
                }
                world.method_8486(entity.method_23317(), entity.method_23318() + (double)entity.method_5751(), entity.method_23321(), class_3417.field_14865, entity.method_5634(), 2.5f, 1.0f, false);
            }
            return valid;
        });
    }

    @FunctionalInterface
    public static interface EggTicker {
        public boolean tick(DragonEggEntity var1, class_1937 var2, class_2338 var3, boolean var4);
    }
}

